/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import java.util.List;
import net.minecraft.util.EnumFacing;
import org.jetbrains.annotations.NotNull;

public class CoverUtil {
    public static Cuboid6 getCoverPlateBox(@NotNull EnumFacing side, double plateThickness) {
        Cuboid6 cuboid6;
        switch (side) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                cuboid6 = new Cuboid6(0.0, 1.0 - plateThickness, 0.0, 1.0, 1.0, 1.0);
                break;
            }
            case DOWN: {
                cuboid6 = new Cuboid6(0.0, 0.0, 0.0, 1.0, plateThickness, 1.0);
                break;
            }
            case NORTH: {
                cuboid6 = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, plateThickness);
                break;
            }
            case SOUTH: {
                cuboid6 = new Cuboid6(0.0, 0.0, 1.0 - plateThickness, 1.0, 1.0, 1.0);
                break;
            }
            case WEST: {
                cuboid6 = new Cuboid6(0.0, 0.0, 0.0, plateThickness, 1.0, 1.0);
                break;
            }
            case EAST: {
                cuboid6 = new Cuboid6(1.0 - plateThickness, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return cuboid6;
    }

    public static boolean doesCoverCollide(@NotNull EnumFacing side, @NotNull List<IndexedCuboid6> collisionBox, double plateThickness) {
        if (plateThickness > 0.0) {
            Cuboid6 coverPlateBox = CoverUtil.getCoverPlateBox(side, plateThickness);
            for (Cuboid6 cuboid6 : collisionBox) {
                if (!cuboid6.intersects(coverPlateBox)) continue;
                return true;
            }
        }
        return false;
    }
}

