/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.RayTracer;
import gregtech.api.cover.CoverableView;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverRayTracer {
    private CoverRayTracer() {
    }

    @Nullable
    public static EnumFacing rayTraceCoverableSide(@NotNull CoverableView coverableView, @NotNull EntityPlayer player) {
        RayTraceResult result;
        RayTraceResult rayTraceResult;
        Block block = coverableView.getWorld().func_180495_p(coverableView.getPos()).func_177230_c();
        if (block instanceof BlockPipe) {
            BlockPipe pipe = (BlockPipe)block;
            rayTraceResult = pipe.getServerCollisionRayTrace(player, coverableView.getPos(), coverableView.getWorld());
        } else {
            rayTraceResult = result = RayTracer.retraceBlock((World)coverableView.getWorld(), (EntityPlayer)player, (BlockPos)coverableView.getPos());
        }
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return CoverRayTracer.traceCoverSide(result);
    }

    @Nullable
    public static EnumFacing traceCoverSide(@NotNull RayTraceResult result) {
        if (result instanceof CuboidRayTraceResult) {
            CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)result;
            if (rayTraceResult.cuboid6.data == null) {
                return CoverRayTracer.determineGridSideHit(result);
            }
            Object object = rayTraceResult.cuboid6.data;
            if (object instanceof CoverSideData) {
                CoverSideData coverSideData = (CoverSideData)object;
                return coverSideData.side;
            }
            object = rayTraceResult.cuboid6.data;
            if (object instanceof BlockPipe.PipeConnectionData) {
                BlockPipe.PipeConnectionData pipeConnectionData = (BlockPipe.PipeConnectionData)object;
                return pipeConnectionData.side;
            }
            object = rayTraceResult.cuboid6.data;
            if (object instanceof PrimaryBoxData) {
                PrimaryBoxData primaryBoxData = (PrimaryBoxData)object;
                return primaryBoxData.usePlacementGrid ? CoverRayTracer.determineGridSideHit(result) : result.field_178784_b;
            }
        }
        return CoverRayTracer.determineGridSideHit(result);
    }

    @Nullable
    public static EnumFacing determineGridSideHit(@NotNull RayTraceResult result) {
        return GTUtility.determineWrenchingSide(result.field_178784_b, (float)(result.field_72307_f.field_72450_a - (double)result.func_178782_a().func_177958_n()), (float)(result.field_72307_f.field_72448_b - (double)result.func_178782_a().func_177956_o()), (float)(result.field_72307_f.field_72449_c - (double)result.func_178782_a().func_177952_p()));
    }

    public static class CoverSideData {
        public final EnumFacing side;

        public CoverSideData(EnumFacing side) {
            this.side = side;
        }
    }

    public static class PrimaryBoxData {
        public final boolean usePlacementGrid;

        public PrimaryBoxData(boolean usePlacementGrid) {
            this.usePlacementGrid = usePlacementGrid;
        }
    }
}

