/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.multiblock.RecipeMapSteamMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SteamMultiblockRecipeLogic
extends AbstractRecipeLogic {
    private IMultipleTankHandler steamFluidTank;
    private IFluidTank steamFluidTankCombined;
    private final double conversionRate;

    public SteamMultiblockRecipeLogic(RecipeMapSteamMultiblockController tileEntity, RecipeMap<?> recipeMap, IMultipleTankHandler steamFluidTank, double conversionRate) {
        super(tileEntity, recipeMap);
        this.steamFluidTank = steamFluidTank;
        this.conversionRate = conversionRate;
        this.setAllowOverclocking(false);
        this.combineSteamTanks();
    }

    public IFluidTank getSteamFluidTankCombined() {
        this.combineSteamTanks();
        return this.steamFluidTankCombined;
    }

    @Override
    protected IItemHandlerModifiable getInputInventory() {
        RecipeMapSteamMultiblockController controller = (RecipeMapSteamMultiblockController)this.metaTileEntity;
        return controller.getInputInventory();
    }

    @Override
    protected IItemHandlerModifiable getOutputInventory() {
        RecipeMapSteamMultiblockController controller = (RecipeMapSteamMultiblockController)this.metaTileEntity;
        return controller.getOutputInventory();
    }

    protected IMultipleTankHandler getSteamFluidTank() {
        RecipeMapSteamMultiblockController controller = (RecipeMapSteamMultiblockController)this.metaTileEntity;
        return controller.getSteamFluidTank();
    }

    private void combineSteamTanks() {
        this.steamFluidTank = this.getSteamFluidTank();
        if (this.steamFluidTank == null) {
            this.steamFluidTankCombined = new FluidTank(0);
        } else {
            int capacity = this.steamFluidTank.getTanks() * 64000;
            this.steamFluidTankCombined = new FluidTank(capacity);
            this.steamFluidTankCombined.fill(this.steamFluidTank.drain(capacity, false), true);
        }
    }

    @Override
    public void update() {
        RecipeMapSteamMultiblockController controller = (RecipeMapSteamMultiblockController)this.metaTileEntity;
        if (this.isActive && !controller.isStructureFormed()) {
            this.progressTime = 0;
            this.wasActiveAndNeedsUpdate = true;
        }
        this.combineSteamTanks();
        super.update();
    }

    @Override
    protected long getEnergyInputPerSecond() {
        return 0L;
    }

    @Override
    protected long getEnergyStored() {
        this.combineSteamTanks();
        return (long)Math.ceil((double)this.steamFluidTankCombined.getFluidAmount() * this.conversionRate);
    }

    @Override
    protected long getEnergyCapacity() {
        this.combineSteamTanks();
        return (long)Math.floor((double)this.steamFluidTankCombined.getCapacity() * this.conversionRate);
    }

    @Override
    protected boolean drawEnergy(long recipeEUt, boolean simulate) {
        this.combineSteamTanks();
        int resultDraw = GTUtility.safeCastLongToInt((long)Math.ceil((double)recipeEUt / this.conversionRate));
        return resultDraw >= 0 && this.steamFluidTankCombined.getFluidAmount() >= resultDraw && this.steamFluidTank.drain(resultDraw, !simulate) != null;
    }

    @Override
    public long getMaxVoltage() {
        return GTValues.V[1];
    }

    @Override
    public boolean isAllowOverclocking() {
        return false;
    }

    @Override
    @Nullable
    protected Recipe setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory) {
        RecipeMapSteamMultiblockController controller = (RecipeMapSteamMultiblockController)this.metaTileEntity;
        if (controller.checkRecipe(recipe, false) && (recipe = super.setupAndConsumeRecipeInputs(recipe, importInventory)) != null) {
            controller.checkRecipe(recipe, true);
            return recipe;
        }
        return null;
    }

    @Override
    protected void completeRecipe() {
        super.completeRecipe();
        this.ventSteam();
    }

    private void ventSteam() {
        BlockPos machinePos = this.metaTileEntity.getPos();
        EnumFacing ventingSide = this.metaTileEntity.getFrontFacing();
        BlockPos ventingBlockPos = machinePos.func_177972_a(ventingSide);
        IBlockState blockOnPos = this.metaTileEntity.getWorld().func_180495_p(ventingBlockPos);
        if (blockOnPos.func_185890_d((IBlockAccess)this.metaTileEntity.getWorld(), ventingBlockPos) == Block.field_185506_k) {
            this.performVentingAnimation(machinePos, ventingSide);
        } else if (blockOnPos.func_177230_c() == Blocks.field_150431_aC && (Integer)blockOnPos.func_177229_b((IProperty)BlockSnow.field_176315_a) == 1) {
            this.performVentingAnimation(machinePos, ventingSide);
            this.metaTileEntity.getWorld().func_175655_b(ventingBlockPos, false);
        }
    }

    private void performVentingAnimation(BlockPos machinePos, EnumFacing ventingSide) {
        WorldServer world = (WorldServer)this.metaTileEntity.getWorld();
        double posX = (double)machinePos.func_177958_n() + 0.5 + (double)ventingSide.func_82601_c() * 0.6;
        double posY = (double)machinePos.func_177956_o() + 0.5 + (double)ventingSide.func_96559_d() * 0.6;
        double posZ = (double)machinePos.func_177952_p() + 0.5 + (double)ventingSide.func_82599_e() * 0.6;
        world.func_175739_a(EnumParticleTypes.CLOUD, posX, posY, posZ, 7 + GTValues.RNG.nextInt(3), (double)ventingSide.func_82601_c() / 2.0, (double)ventingSide.func_96559_d() / 2.0, (double)ventingSide.func_82599_e() / 2.0, 0.1, new int[0]);
        if (ConfigHolder.machines.machineSounds && !this.metaTileEntity.isMuffled()) {
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean hasEnoughPower(long eut, int duration) {
        long totalSteam = (long)((double)(eut * (long)duration) / this.conversionRate);
        if (totalSteam > 0L) {
            long steamStored = this.getEnergyStored();
            long steamCapacity = this.getEnergyCapacity();
            if (steamCapacity < totalSteam) {
                return steamCapacity == steamStored;
            }
            return steamStored >= totalSteam;
        }
        return super.hasEnoughPower(eut, duration);
    }
}

