/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.IVentable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.logic.OCResult;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtech.core.advancement.AdvancementTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;

public class RecipeLogicSteam
extends AbstractRecipeLogic
implements IVentable {
    private final IFluidTank steamFluidTank;
    private final boolean isHighPressure;
    private final double conversionRate;
    private boolean needsVenting;
    private boolean ventingStuck;
    private EnumFacing ventingSide;

    public RecipeLogicSteam(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean isHighPressure, IFluidTank steamFluidTank, double conversionRate) {
        super(tileEntity, recipeMap);
        this.steamFluidTank = steamFluidTank;
        this.conversionRate = conversionRate;
        this.isHighPressure = isHighPressure;
    }

    @Override
    public boolean isVentingStuck() {
        return this.needsVenting && this.ventingStuck;
    }

    @Override
    public boolean isNeedsVenting() {
        return this.needsVenting;
    }

    @Override
    public void onFrontFacingSet(EnumFacing newFrontFacing) {
        if (this.ventingSide == null) {
            this.setVentingSide(newFrontFacing.func_176734_d());
        }
    }

    public EnumFacing getVentingSide() {
        return this.ventingSide == null ? EnumFacing.SOUTH : this.ventingSide;
    }

    public void setVentingStuck(boolean ventingStuck) {
        this.ventingStuck = ventingStuck;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(GregtechDataCodes.VENTING_STUCK, buf -> buf.writeBoolean(ventingStuck));
        }
    }

    @Override
    public void setNeedsVenting(boolean needsVenting) {
        this.needsVenting = needsVenting;
        if (!needsVenting && this.ventingStuck) {
            this.setVentingStuck(false);
        }
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(GregtechDataCodes.NEEDS_VENTING, buf -> buf.writeBoolean(needsVenting));
        }
    }

    public void setVentingSide(EnumFacing ventingSide) {
        this.ventingSide = ventingSide;
        if (!this.metaTileEntity.getWorld().field_72995_K) {
            this.metaTileEntity.markDirty();
            this.writeCustomData(GregtechDataCodes.VENTING_SIDE, buf -> buf.writeByte(ventingSide.func_176745_a()));
        }
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.NEEDS_VENTING) {
            this.needsVenting = buf.readBoolean();
        } else if (dataId == GregtechDataCodes.VENTING_SIDE) {
            this.ventingSide = EnumFacing.field_82609_l[buf.readByte()];
            this.getMetaTileEntity().scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.VENTING_STUCK) {
            this.ventingStuck = buf.readBoolean();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getVentingSide().func_176745_a());
        buf.writeBoolean(this.needsVenting);
        buf.writeBoolean(this.ventingStuck);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.ventingSide = EnumFacing.field_82609_l[buf.readByte()];
        this.needsVenting = buf.readBoolean();
        this.ventingStuck = buf.readBoolean();
    }

    @Override
    public void tryDoVenting() {
        BlockPos machinePos = this.metaTileEntity.getPos();
        EnumFacing ventingSide = this.getVentingSide();
        BlockPos ventingBlockPos = machinePos.func_177972_a(ventingSide);
        IBlockState blockOnPos = this.metaTileEntity.getWorld().func_180495_p(ventingBlockPos);
        if (blockOnPos.func_185890_d((IBlockAccess)this.metaTileEntity.getWorld(), ventingBlockPos) == Block.field_185506_k) {
            this.performVentingAnimation(ventingBlockPos, machinePos);
        } else if (GTUtility.tryBreakSnow(this.metaTileEntity.getWorld(), ventingBlockPos, blockOnPos, false)) {
            this.performVentingAnimation(ventingBlockPos, machinePos);
        } else if (!this.ventingStuck) {
            this.setVentingStuck(true);
        }
    }

    private void performVentingAnimation(BlockPos ventingBlockPos, BlockPos machinePos) {
        this.metaTileEntity.getWorld().func_175647_a(EntityLivingBase.class, new AxisAlignedBB(ventingBlockPos), EntitySelectors.field_188444_d).forEach(entity -> {
            entity.func_70097_a(DamageSources.getHeatDamage(), this.isHighPressure ? 12.0f : 6.0f);
            if (entity instanceof EntityPlayerMP) {
                AdvancementTriggers.STEAM_VENT_DEATH.trigger((EntityPlayerMP)entity);
            }
        });
        WorldServer world = (WorldServer)this.metaTileEntity.getWorld();
        double posX = (double)machinePos.func_177958_n() + 0.5 + (double)this.ventingSide.func_82601_c() * 0.6;
        double posY = (double)machinePos.func_177956_o() + 0.5 + (double)this.ventingSide.func_96559_d() * 0.6;
        double posZ = (double)machinePos.func_177952_p() + 0.5 + (double)this.ventingSide.func_82599_e() * 0.6;
        world.func_175739_a(EnumParticleTypes.CLOUD, posX, posY, posZ, 7 + world.field_73012_v.nextInt(3), (double)this.ventingSide.func_82601_c() / 2.0, (double)this.ventingSide.func_96559_d() / 2.0, (double)this.ventingSide.func_82599_e() / 2.0, 0.1, new int[0]);
        if (ConfigHolder.machines.machineSounds && !this.metaTileEntity.isMuffled()) {
            world.func_184148_a(null, posX, posY, posZ, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.setNeedsVenting(false);
    }

    @Override
    public void update() {
        if (this.getMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (this.needsVenting && this.metaTileEntity.getOffsetTimer() % 10L == 0L) {
            this.tryDoVenting();
        }
        super.update();
    }

    @Override
    public boolean checkRecipe(@NotNull Recipe recipe) {
        return super.checkRecipe(recipe) && !this.needsVenting;
    }

    @Override
    protected void completeRecipe() {
        super.completeRecipe();
        this.setNeedsVenting(true);
        this.tryDoVenting();
    }

    @Override
    protected void performOverclocking(@NotNull Recipe recipe, @NotNull OCParams ocParams, @NotNull OCResult ocResult) {
        if (this.isHighPressure) {
            ocResult.init(recipe.getEUt() * 2L, recipe.getDuration());
        } else {
            ocResult.init(recipe.getEUt(), recipe.getDuration() * 2);
        }
    }

    @Override
    protected long getEnergyInputPerSecond() {
        return 0L;
    }

    @Override
    protected long getEnergyStored() {
        return (long)Math.ceil((double)this.steamFluidTank.getFluidAmount() * this.conversionRate);
    }

    @Override
    protected long getEnergyCapacity() {
        return (long)Math.floor((double)this.steamFluidTank.getCapacity() * this.conversionRate);
    }

    @Override
    protected boolean drawEnergy(long recipeEUt, boolean simulate) {
        int resultDraw = GTUtility.safeCastLongToInt((long)Math.ceil((double)recipeEUt / this.conversionRate));
        return resultDraw >= 0 && this.steamFluidTank.getFluidAmount() >= resultDraw && this.steamFluidTank.drain(resultDraw, !simulate) != null;
    }

    @Override
    public long getMaxVoltage() {
        return GTValues.V[1];
    }

    @Override
    protected boolean hasEnoughPower(long eut, int duration) {
        long totalSteam = (long)((double)(eut * (long)duration) / this.conversionRate);
        if (totalSteam > 0L) {
            long steamStored = this.getEnergyStored();
            long steamCapacity = this.getEnergyCapacity();
            if (steamCapacity < totalSteam) {
                return steamCapacity == steamStored;
            }
            return steamStored >= totalSteam;
        }
        return super.hasEnoughPower(eut, duration);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("VentingSide", this.getVentingSide().func_176745_a());
        compound.func_74757_a("NeedsVenting", this.needsVenting);
        compound.func_74757_a("VentingStuck", this.ventingStuck);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.ventingSide = EnumFacing.field_82609_l[compound.func_74762_e("VentingSide")];
        this.needsVenting = compound.func_74767_n("NeedsVenting");
        this.ventingStuck = compound.func_74767_n("VentingStuck");
    }
}

