/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import com.google.common.collect.Iterables;
import gregtech.api.capability.IFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public final class MultiFluidFilter
implements IFilter<FluidStack> {
    private final boolean blacklist;
    private final FluidStack[] fluids;

    public MultiFluidFilter(boolean blacklist, FluidStack ... fluids) {
        this.blacklist = blacklist;
        this.fluids = fluids;
    }

    public MultiFluidFilter(boolean blacklist, Iterable<FluidStack> fluids) {
        this.blacklist = blacklist;
        this.fluids = (FluidStack[])Iterables.toArray(fluids, FluidStack.class);
    }

    @NotNull
    public List<FluidStack> getFluids() {
        return Collections.unmodifiableList(Arrays.asList(this.fluids));
    }

    public boolean isWhitelist() {
        return !this.blacklist;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean test(@NotNull FluidStack fluidStack) {
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPriority() {
        return this.fluids.length == 0 ? IFilter.noPriority() : (this.blacklist ? IFilter.blacklistPriority(this.fluids.length) : IFilter.whitelistPriority(this.fluids.length));
    }

    @Override
    @NotNull
    public IFilter<FluidStack> negate() {
        return new MultiFluidFilter(!this.blacklist, this.fluids);
    }

    public String toString() {
        return "MultiFluidFilter{blacklist=" + this.blacklist + ", fluids=" + Arrays.toString(this.fluids) + '}';
    }
}

