/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.ILaserContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class LaserContainerHandler
extends EnergyContainerHandler
implements ILaserContainer {
    public LaserContainerHandler(MetaTileEntity tileEntity, long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        super(tileEntity, maxCapacity, maxInputVoltage, maxInputAmperage, maxOutputVoltage, maxOutputAmperage);
    }

    public static LaserContainerHandler emitterContainer(MetaTileEntity tileEntity, long maxCapacity, long maxOutputVoltage, long maxOutputAmperage) {
        return new LaserContainerHandler(tileEntity, maxCapacity, 0L, 0L, maxOutputVoltage, maxOutputAmperage);
    }

    public static LaserContainerHandler receiverContainer(MetaTileEntity tileEntity, long maxCapacity, long maxInputVoltage, long maxInputAmperage) {
        return new LaserContainerHandler(tileEntity, maxCapacity, maxInputVoltage, maxInputAmperage, 0L, 0L);
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_LASER) {
            return (T)GregtechTileCapabilities.CAPABILITY_LASER.cast((Object)this);
        }
        return null;
    }

    @Override
    public void update() {
        this.amps = 0L;
        if (this.getMetaTileEntity().getWorld().field_72995_K) {
            return;
        }
        if (this.metaTileEntity.getOffsetTimer() % 20L == 0L) {
            this.lastEnergyOutputPerSec = this.energyOutputPerSec;
            this.lastEnergyInputPerSec = this.energyInputPerSec;
            this.energyOutputPerSec = 0L;
            this.energyInputPerSec = 0L;
        }
        if (this.getEnergyStored() >= this.getOutputVoltage() && this.getOutputVoltage() > 0L && this.getOutputAmperage() > 0L) {
            long outputVoltage = this.getOutputVoltage();
            long outputAmperes = Math.min(this.getEnergyStored() / outputVoltage, this.getOutputAmperage());
            if (outputAmperes == 0L) {
                return;
            }
            long amperesUsed = 0L;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IEnergyContainer energyContainer;
                if (!this.outputsEnergy(side)) continue;
                TileEntity tileEntity = this.metaTileEntity.getWorld().func_175625_s(this.metaTileEntity.getPos().func_177972_a(side));
                EnumFacing oppositeSide = side.func_176734_d();
                if (tileEntity != null && tileEntity.hasCapability(GregtechTileCapabilities.CAPABILITY_LASER, oppositeSide) && (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_LASER, oppositeSide)) != null && energyContainer.inputsEnergy(oppositeSide) && (amperesUsed += energyContainer.acceptEnergyFromNetwork(oppositeSide, outputVoltage, outputAmperes - amperesUsed)) == outputAmperes) break;
            }
            if (amperesUsed > 0L) {
                this.setEnergyStored(this.getEnergyStored() - amperesUsed * outputVoltage);
            }
        }
    }

    @Override
    public String toString() {
        return "LaserContainerHandler{maxCapacity=" + this.maxCapacity + ", energyStored=" + this.energyStored + ", maxInputVoltage=" + this.getInputVoltage() + ", maxInputAmperage=" + this.getInputAmperage() + ", maxOutputVoltage=" + this.getOutputVoltage() + ", maxOutputAmperage=" + this.getOutputAmperage() + ", amps=" + this.amps + '}';
    }
}

