/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemHandlerList
implements IItemHandlerModifiable {
    private final Int2ObjectMap<IItemHandler> handlerBySlotIndex = new Int2ObjectOpenHashMap();
    private final Object2IntMap<IItemHandler> baseIndexOffset = new Object2IntArrayMap();

    public ItemHandlerList(List<? extends IItemHandler> itemHandlerList) {
        int currentSlotIndex = 0;
        for (IItemHandler iItemHandler : itemHandlerList) {
            if (this.baseIndexOffset.containsKey((Object)iItemHandler)) {
                throw new IllegalArgumentException("Attempted to add item handler " + iItemHandler + " twice");
            }
            this.baseIndexOffset.put((Object)iItemHandler, currentSlotIndex);
            int slotsCount = iItemHandler.getSlots();
            for (int slotIndex = 0; slotIndex < slotsCount; ++slotIndex) {
                this.handlerBySlotIndex.put(currentSlotIndex + slotIndex, (Object)iItemHandler);
            }
            currentSlotIndex += slotsCount;
        }
    }

    public int getIndexOffset(IItemHandler handler) {
        return (Integer)this.baseIndexOffset.getOrDefault((Object)handler, (Object)-1);
    }

    public int getSlots() {
        return this.handlerBySlotIndex.size();
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        if (this.invalidSlot(slot)) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        int actualSlot = slot - (Integer)this.baseIndexOffset.get((Object)itemHandler);
        if (itemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)itemHandler;
            modifiable.setStackInSlot(actualSlot, stack);
        } else {
            itemHandler.extractItem(actualSlot, Integer.MAX_VALUE, false);
            itemHandler.insertItem(actualSlot, stack, false);
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.invalidSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.getStackInSlot(slot - (Integer)this.baseIndexOffset.get((Object)itemHandler));
    }

    public int getSlotLimit(int slot) {
        if (this.invalidSlot(slot)) {
            return 0;
        }
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.getSlotLimit(slot - (Integer)this.baseIndexOffset.get((Object)itemHandler));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.invalidSlot(slot)) {
            return stack;
        }
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.insertItem(slot - (Integer)this.baseIndexOffset.get((Object)itemHandler), stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.invalidSlot(slot)) {
            return ItemStack.field_190927_a;
        }
        IItemHandler itemHandler = (IItemHandler)this.handlerBySlotIndex.get(slot);
        return itemHandler.extractItem(slot - (Integer)this.baseIndexOffset.get((Object)itemHandler), amount, simulate);
    }

    @NotNull
    public Collection<IItemHandler> getBackingHandlers() {
        return Collections.unmodifiableCollection(this.baseIndexOffset.keySet());
    }

    private boolean invalidSlot(int slot) {
        return slot < 0 && slot >= this.getSlots();
    }
}

