/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public class FilteredItemHandler
extends GTItemStackHandler {
    private Predicate<ItemStack> fillPredicate;

    public static Predicate<ItemStack> getCapabilityFilter(Capability<?> cap) {
        return stack -> stack.hasCapability(cap, null);
    }

    public FilteredItemHandler(MetaTileEntity metaTileEntity) {
        super(metaTileEntity, 1);
    }

    public FilteredItemHandler(MetaTileEntity metaTileEntity, int size) {
        super(metaTileEntity, size);
    }

    public FilteredItemHandler(MetaTileEntity metaTileEntity, NonNullList<ItemStack> stacks) {
        super(metaTileEntity, stacks);
    }

    public FilteredItemHandler setFillPredicate(Predicate<ItemStack> fillPredicate) {
        this.fillPredicate = fillPredicate;
        return this;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.fillPredicate == null || this.fillPredicate.test(stack);
    }
}

