/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.multiblock.AbilityInstances;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.util.GTLog;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.NotNull;

public class DistillationTowerLogicHandler {
    protected final IDistillationTower tower;
    private int layerCount;
    private List<IFluidHandler> orderedFluidOutputs;
    private IMultipleTankHandler fluidTanks;

    public DistillationTowerLogicHandler(IDistillationTower tower) {
        this.tower = tower;
    }

    public boolean applyFluidToOutputs(List<FluidStack> fluids, boolean doFill) {
        boolean valid = true;
        for (int i = 0; i < Math.min(fluids.size(), this.getOrderedFluidOutputs().size()); ++i) {
            IFluidHandler handler = this.getOrderedFluidOutputs().get(i);
            int accepted = handler.fill(fluids.get(i), doFill);
            if (accepted != fluids.get((int)i).amount) {
                valid = false;
            }
            if (!doFill && !valid) break;
        }
        return valid;
    }

    public void determineLayerCount(@NotNull BlockPattern structurePattern) {
        this.setLayerCount(structurePattern.formedRepetitionCount[1] + 1);
    }

    public void determineOrderedFluidOutputs() {
        List fluidExportParts = this.tower.getMultiblockParts().stream().filter(iMultiblockPart -> {
            IMultiblockAbilityPart abilityPart;
            return iMultiblockPart instanceof IMultiblockAbilityPart && (abilityPart = (IMultiblockAbilityPart)iMultiblockPart).getAbilities().contains(MultiblockAbility.EXPORT_FLUIDS) && abilityPart instanceof MetaTileEntityMultiblockPart;
        }).map(iMultiblockPart -> (MetaTileEntityMultiblockPart)iMultiblockPart).collect(Collectors.toList());
        ObjectArrayList orderedHandlerList = new ObjectArrayList();
        ObjectArrayList tankList = new ObjectArrayList();
        int firstY = this.tower.getPos().func_177956_o() + 1;
        int exportIndex = 0;
        for (int y = firstY; y < firstY + this.getLayerCount(); ++y) {
            if (fluidExportParts.size() <= exportIndex) {
                orderedHandlerList.add(FakeTank.INSTANCE);
                tankList.add(FakeTank.INSTANCE);
                continue;
            }
            MetaTileEntityMultiblockPart part = (MetaTileEntityMultiblockPart)fluidExportParts.get(exportIndex);
            if (part.getPos().func_177956_o() == y) {
                AbilityInstances hatchTanks = new AbilityInstances(MultiblockAbility.EXPORT_FLUIDS);
                ((IMultiblockAbilityPart)((Object)part)).registerAbilities(hatchTanks);
                orderedHandlerList.add(new FluidTankList(false, hatchTanks.cast()));
                tankList.addAll(hatchTanks.cast());
                ++exportIndex;
                continue;
            }
            if (part.getPos().func_177956_o() > y) {
                orderedHandlerList.add(FakeTank.INSTANCE);
                tankList.add(FakeTank.INSTANCE);
                continue;
            }
            GTLog.logger.error("The Distillation Tower at {} had a fluid export hatch with an unexpected Y position.", (Object)this.tower.getPos());
            this.tower.invalidateStructure();
            this.setOrderedFluidOutputs((List<IFluidHandler>)new ObjectArrayList());
            this.setFluidTanks(new FluidTankList(false, new IFluidTank[0]));
        }
        this.setOrderedFluidOutputs((List<IFluidHandler>)orderedHandlerList);
        this.setFluidTanks(new FluidTankList(this.tower.allowSameFluidFillForOutputs(), (List<? extends IFluidTank>)tankList));
    }

    public void invalidate() {
        this.setLayerCount(0);
        this.setOrderedFluidOutputs(null);
    }

    protected void setLayerCount(int layerCount) {
        this.layerCount = layerCount;
    }

    public int getLayerCount() {
        return this.layerCount;
    }

    protected void setOrderedFluidOutputs(List<IFluidHandler> orderedFluidOutputs) {
        this.orderedFluidOutputs = orderedFluidOutputs;
    }

    public List<IFluidHandler> getOrderedFluidOutputs() {
        return this.orderedFluidOutputs;
    }

    protected void setFluidTanks(IMultipleTankHandler fluidTanks) {
        this.fluidTanks = fluidTanks;
    }

    public IMultipleTankHandler getFluidTanks() {
        return this.fluidTanks;
    }

    protected static class FakeTank
    implements IFluidHandler,
    IFluidTank {
        protected static final FakeTank INSTANCE = new FakeTank();
        public static final FluidTankInfo FAKE_TANK_INFO = new FluidTankInfo(null, Integer.MAX_VALUE);
        public static final IFluidTankProperties FAKE_TANK_PROPERTIES = new FluidTankProperties(null, Integer.MAX_VALUE, true, false);
        public static final IFluidTankProperties[] FAKE_TANK_PROPERTIES_ARRAY = new IFluidTankProperties[]{FAKE_TANK_PROPERTIES};

        protected FakeTank() {
        }

        public IFluidTankProperties[] getTankProperties() {
            return FAKE_TANK_PROPERTIES_ARRAY;
        }

        public FluidStack getFluid() {
            return null;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        public FluidTankInfo getInfo() {
            return FAKE_TANK_INFO;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return resource.amount;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

