/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IOpticalComputationProvider;
import gregtech.api.capability.IOpticalComputationReceiver;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.properties.impl.ComputationProperty;
import gregtech.api.recipes.properties.impl.TotalComputationProperty;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class ComputationRecipeLogic
extends MultiblockRecipeLogic {
    private final ComputationType type;
    private boolean isDurationTotalCWU;
    private int recipeCWUt;
    private boolean hasNotEnoughComputation;
    private int currentDrawnCWUt;

    public ComputationRecipeLogic(RecipeMapMultiblockController metaTileEntity, ComputationType type) {
        super(metaTileEntity);
        this.type = type;
        if (!(metaTileEntity instanceof IOpticalComputationReceiver)) {
            throw new IllegalArgumentException("MetaTileEntity must be instanceof IOpticalComputationReceiver");
        }
    }

    @NotNull
    public IOpticalComputationProvider getComputationProvider() {
        IOpticalComputationReceiver controller = (IOpticalComputationReceiver)((Object)this.metaTileEntity);
        return controller.getComputationProvider();
    }

    @Override
    public boolean checkRecipe(@NotNull Recipe recipe) {
        if (!super.checkRecipe(recipe)) {
            return false;
        }
        int recipeCWUt = recipe.getProperty(ComputationProperty.getInstance(), 0);
        if (recipeCWUt == 0) {
            return true;
        }
        IOpticalComputationProvider provider = this.getComputationProvider();
        return provider.requestCWUt(recipeCWUt, true) >= recipeCWUt;
    }

    @Override
    protected void setupRecipe(@NotNull Recipe recipe) {
        super.setupRecipe(recipe);
        this.recipeCWUt = recipe.getProperty(ComputationProperty.getInstance(), 0);
        this.isDurationTotalCWU = recipe.hasProperty(TotalComputationProperty.getInstance());
    }

    @Override
    protected void updateRecipeProgress() {
        if (this.recipeCWUt == 0) {
            super.updateRecipeProgress();
            return;
        }
        if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
            this.drawEnergy(this.recipeEUt, false);
            IOpticalComputationProvider provider = this.getComputationProvider();
            int availableCWUt = provider.requestCWUt(Integer.MAX_VALUE, true);
            if (availableCWUt >= this.recipeCWUt) {
                this.hasNotEnoughComputation = false;
                if (this.isDurationTotalCWU) {
                    this.currentDrawnCWUt = provider.requestCWUt(availableCWUt, false);
                    this.progressTime += this.currentDrawnCWUt;
                } else {
                    provider.requestCWUt(this.recipeCWUt, false);
                    ++this.progressTime;
                }
                if (this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
            } else {
                this.currentDrawnCWUt = 0;
                this.hasNotEnoughComputation = true;
                if (this.type == ComputationType.STEADY) {
                    this.decreaseProgress();
                }
            }
            if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * this.recipeEUt) {
                this.hasNotEnoughEnergy = false;
            }
        } else if (this.recipeEUt > 0L) {
            this.hasNotEnoughEnergy = true;
            this.decreaseProgress();
        }
    }

    @Override
    protected void completeRecipe() {
        super.completeRecipe();
        this.recipeCWUt = 0;
        this.isDurationTotalCWU = false;
        this.hasNotEnoughComputation = false;
        this.currentDrawnCWUt = 0;
    }

    public int getRecipeCWUt() {
        return this.recipeCWUt;
    }

    public int getCurrentDrawnCWUt() {
        return this.isDurationTotalCWU ? this.currentDrawnCWUt : this.recipeCWUt;
    }

    public boolean isHasNotEnoughComputation() {
        return this.hasNotEnoughComputation;
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        if (this.progressTime > 0) {
            compound.func_74768_a("RecipeCWUt", this.recipeCWUt);
            compound.func_74757_a("IsDurationTotalCWU", this.isDurationTotalCWU);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        super.deserializeNBT(compound);
        if (this.progressTime > 0) {
            this.recipeCWUt = compound.func_74762_e("RecipeCWUt");
            this.isDurationTotalCWU = compound.func_74767_n("IsDurationTotalCWU");
        }
    }

    public boolean shouldShowDuration() {
        return !this.isDurationTotalCWU;
    }

    public static enum ComputationType {
        STEADY,
        SPORADIC;

    }
}

