/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IFilter;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.common.ConfigHolder;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public enum CommonFluidFilters implements IFilter<FluidStack>
{
    ALLOW_ALL{

        @Override
        public boolean test(@NotNull FluidStack fluid) {
            return true;
        }

        @Override
        public int getPriority() {
            return IFilter.noPriority();
        }

        @Override
        public IFilter<FluidStack> negate() {
            return DISALLOW_ALL;
        }
    }
    ,
    DISALLOW_ALL{

        @Override
        public boolean test(@NotNull FluidStack fluid) {
            return false;
        }

        @Override
        public int getPriority() {
            return IFilter.noPriority();
        }

        @Override
        public IFilter<FluidStack> negate() {
            return ALLOW_ALL;
        }
    }
    ,
    BOILER_FLUID{

        @Override
        public boolean test(@NotNull FluidStack fluid) {
            if (3.matchesFluid(fluid, FluidRegistry.WATER) || 3.matchesFluid(fluid, Materials.DistilledWater)) {
                return true;
            }
            for (String fluidName : ConfigHolder.machines.boilerFluids) {
                Fluid boilerFluid = FluidRegistry.getFluid((String)fluidName);
                if (boilerFluid == null || !3.matchesFluid(fluid, boilerFluid)) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getPriority() {
            return IFilter.whitelistLikePriority();
        }
    }
    ,
    STEAM{

        @Override
        public boolean test(@NotNull FluidStack fluid) {
            return 4.matchesFluid(fluid, Materials.Steam);
        }

        @Override
        public int getPriority() {
            return IFilter.whitelistPriority(1);
        }
    }
    ,
    LIGHTER_FUEL{

        @Override
        public boolean test(@NotNull FluidStack fluidStack) {
            return 5.matchesFluid(fluidStack, Materials.Butane) || 5.matchesFluid(fluidStack, Materials.Propane);
        }

        @Override
        public int getPriority() {
            return IFilter.whitelistPriority(2);
        }
    };


    public static boolean matchesFluid(@NotNull FluidStack fluidStack, @NotNull Material fluidMaterial) {
        return fluidStack.tag == null && fluidStack.getFluid() == fluidMaterial.getFluid();
    }

    public static boolean matchesFluid(@NotNull FluidStack fluidStack, @NotNull Fluid fluid) {
        return fluidStack.tag == null && fluidStack.getFluid() == fluid;
    }
}

