/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedCapabilityProvider
implements ICapabilityProvider {
    private final ICapabilityProvider[] providers;

    public CombinedCapabilityProvider(ICapabilityProvider ... providers) {
        this.providers = providers;
    }

    public CombinedCapabilityProvider(List<ICapabilityProvider> providers) {
        this.providers = providers.toArray(new ICapabilityProvider[0]);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        for (ICapabilityProvider provider : this.providers) {
            if (!provider.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        for (ICapabilityProvider provider : this.providers) {
            Object cap = provider.getCapability(capability, facing);
            if (cap == null) continue;
            return (T)cap;
        }
        return null;
    }
}

