/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.IMaintenance;
import gregtech.common.ConfigHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class CleanroomLogic {
    public static final int BASE_CLEAN_AMOUNT = 5;
    private int maxProgress = 0;
    private int progressTime = 0;
    private int minEnergyTier;
    private final MetaTileEntity metaTileEntity;
    private final boolean hasMaintenance;
    private boolean isActive;
    private boolean isWorkingEnabled = true;
    private boolean wasActiveAndNeedsUpdate;
    private boolean hasNotEnoughEnergy;

    public CleanroomLogic(MetaTileEntity metaTileEntity, int minEnergyTier) {
        this.metaTileEntity = metaTileEntity;
        this.minEnergyTier = minEnergyTier;
        this.hasMaintenance = ConfigHolder.machines.enableMaintenance && ((IMaintenance)((Object)metaTileEntity)).hasMaintenanceMechanics();
    }

    public void updateLogic() {
        if (!this.isWorkingEnabled) {
            return;
        }
        if (this.hasMaintenance && ((IMaintenance)((Object)this.metaTileEntity)).getNumMaintenanceProblems() > 5) {
            return;
        }
        if (!this.isVoltageHighEnough()) {
            return;
        }
        if (!this.consumeEnergy(true)) {
            if (this.progressTime >= 2) {
                this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
            }
            this.hasNotEnoughEnergy = true;
            if (this.metaTileEntity.getOffsetTimer() % (long)this.maxProgress == 0L) {
                this.adjustCleanAmount(true);
            }
            return;
        }
        this.consumeEnergy(false);
        if (!this.isActive) {
            this.setActive(true);
        }
        ++this.progressTime;
        if (this.progressTime % this.getMaxProgress() != 0) {
            return;
        }
        this.progressTime = 0;
        this.adjustCleanAmount(false);
    }

    protected void adjustCleanAmount(boolean shouldRemove) {
        int amountToClean = 5 * (this.getTierDifference() + 1);
        if (shouldRemove) {
            amountToClean *= -1;
        }
        if (this.hasMaintenance) {
            amountToClean -= ((IMaintenance)((Object)this.metaTileEntity)).getNumMaintenanceProblems();
        }
        ((ICleanroomProvider)((Object)this.metaTileEntity)).adjustCleanAmount(amountToClean);
    }

    protected boolean consumeEnergy(boolean simulate) {
        return ((ICleanroomProvider)((Object)this.metaTileEntity)).drainEnergy(simulate);
    }

    public void invalidate() {
        this.progressTime = 0;
        this.maxProgress = 0;
        this.setActive(false);
    }

    public boolean isActive() {
        return this.isActive && this.isWorkingEnabled();
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.metaTileEntity.markDirty();
            World world = this.metaTileEntity.getWorld();
            if (world != null && !world.field_72995_K) {
                this.metaTileEntity.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.metaTileEntity.markDirty();
        World world = this.metaTileEntity.getWorld();
        if (world != null && !world.field_72995_K) {
            this.metaTileEntity.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    public boolean isVoltageHighEnough() {
        return this.minEnergyTier <= ((ICleanroomProvider)((Object)this.metaTileEntity)).getEnergyTier();
    }

    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    public boolean isWorking() {
        return this.isActive && !this.hasNotEnoughEnergy && this.isWorkingEnabled;
    }

    public int getProgressTime() {
        return this.progressTime;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getProgressPercent() {
        return (int)(1.0f * (float)this.getProgressTime() / (float)this.getMaxProgress() * 100.0f);
    }

    protected int getTierDifference() {
        return ((ICleanroomProvider)((Object)this.metaTileEntity)).getEnergyTier() - this.minEnergyTier;
    }

    public void setMinEnergyTier(int energyTier) {
        this.minEnergyTier = energyTier;
    }

    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound data) {
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        data.func_74757_a("wasActiveAndNeedsUpdate", this.wasActiveAndNeedsUpdate);
        data.func_74768_a("progressTime", this.progressTime);
        data.func_74768_a("maxProgress", this.maxProgress);
        return data;
    }

    public void readFromNBT(@NotNull NBTTagCompound data) {
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        this.wasActiveAndNeedsUpdate = data.func_74767_n("wasActiveAndNeedsUpdate");
        this.progressTime = data.func_74762_e("progressTime");
        this.maxProgress = data.func_74762_e("maxProgress");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
        buf.writeBoolean(this.wasActiveAndNeedsUpdate);
        buf.writeInt(this.progressTime);
        buf.writeInt(this.maxProgress);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.setActive(buf.readBoolean());
        this.setWorkingEnabled(buf.readBoolean());
        this.setWasActiveAndNeedsUpdate(buf.readBoolean());
        this.progressTime = buf.readInt();
        this.maxProgress = buf.readInt();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.setActive(buf.readBoolean());
            this.metaTileEntity.scheduleRenderUpdate();
        }
    }

    public boolean wasActiveAndNeedsUpdate() {
        return this.wasActiveAndNeedsUpdate;
    }

    public void setWasActiveAndNeedsUpdate(boolean wasActiveAndNeedsUpdate) {
        this.wasActiveAndNeedsUpdate = wasActiveAndNeedsUpdate;
    }
}

