/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.multiblock.CleanroomType;
import gregtech.api.metatileentity.multiblock.ICleanroomProvider;
import gregtech.api.metatileentity.multiblock.ICleanroomReceiver;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.logic.IParallelableRecipeLogic;
import gregtech.api.recipes.logic.OCParams;
import gregtech.api.recipes.logic.OCResult;
import gregtech.api.recipes.logic.OverclockingLogic;
import gregtech.api.recipes.properties.RecipePropertyStorage;
import gregtech.api.recipes.properties.impl.CleanroomProperty;
import gregtech.api.recipes.properties.impl.DimensionProperty;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeLogic
extends MTETrait
implements IWorkable,
IParallelableRecipeLogic {
    private static final String ALLOW_OVERCLOCKING = "AllowOverclocking";
    private static final String OVERCLOCK_VOLTAGE = "OverclockVoltage";
    private final RecipeMap<?> recipeMap;
    private double euDiscount = -1.0;
    private double speedBonus = -1.0;
    protected Recipe previousRecipe;
    private boolean allowOverclocking = true;
    protected int parallelRecipesPerformed;
    private long overclockVoltage;
    private final OCParams ocParams = new OCParams();
    private final OCResult ocResult = new OCResult();
    protected boolean canRecipeProgress = true;
    protected int progressTime;
    protected int maxProgressTime;
    protected long recipeEUt;
    @NotNull
    protected List<FluidStack> fluidOutputs = Collections.emptyList();
    @NotNull
    protected List<ItemStack> itemOutputs = Collections.emptyList();
    protected boolean isActive;
    protected boolean workingEnabled = true;
    protected boolean hasNotEnoughEnergy;
    protected boolean wasActiveAndNeedsUpdate;
    protected boolean isOutputsFull;
    protected boolean invalidInputsForRecipes;
    protected boolean hasPerfectOC;
    private int parallelLimit = 1;

    public AbstractRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap) {
        super(tileEntity);
        this.recipeMap = recipeMap;
    }

    public AbstractRecipeLogic(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, boolean hasPerfectOC) {
        super(tileEntity);
        this.recipeMap = recipeMap;
        this.hasPerfectOC = hasPerfectOC;
    }

    protected long getEnergyInputPerSecond() {
        return this.getEnergyContainer().getInputPerSec();
    }

    protected long getEnergyStored() {
        return this.getEnergyContainer().getEnergyStored();
    }

    protected long getEnergyCapacity() {
        return this.getEnergyContainer().getEnergyCapacity();
    }

    protected IEnergyContainer getEnergyContainer() {
        return IEnergyContainer.DEFAULT;
    }

    protected boolean drawEnergy(long recipeEUt, boolean simulate) {
        long resultEnergy;
        if (this.consumesEnergy()) {
            recipeEUt = -recipeEUt;
        }
        if ((resultEnergy = this.getEnergyStored() + recipeEUt) >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            if (!simulate) {
                this.getEnergyContainer().changeEnergy(recipeEUt);
            }
            return true;
        }
        return false;
    }

    public long getMaxVoltage() {
        return Math.max(this.getEnergyContainer().getInputVoltage(), this.getEnergyContainer().getOutputVoltage());
    }

    protected long getMaxParallelVoltage() {
        return this.getMaxVoltage();
    }

    protected IItemHandlerModifiable getInputInventory() {
        return this.metaTileEntity.getImportItems();
    }

    protected IItemHandlerModifiable getOutputInventory() {
        return this.metaTileEntity.getExportItems();
    }

    protected IMultipleTankHandler getInputTank() {
        return this.metaTileEntity.getImportFluids();
    }

    protected IMultipleTankHandler getOutputTank() {
        return this.metaTileEntity.getExportFluids();
    }

    public boolean consumesEnergy() {
        return true;
    }

    @Override
    @NotNull
    public final String getName() {
        return "RecipeMapWorkable";
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC) {
            return (T)GregtechTileCapabilities.CAPABILITY_RECIPE_LOGIC.cast((Object)this);
        }
        return null;
    }

    @Override
    public void update() {
        World world = this.getMetaTileEntity().getWorld();
        if (world != null && !world.field_72995_K) {
            if (this.workingEnabled) {
                if (this.getMetaTileEntity().getOffsetTimer() % 20L == 0L) {
                    this.canRecipeProgress = this.canProgressRecipe();
                }
                if (this.progressTime > 0) {
                    this.updateRecipeProgress();
                }
                if (this.progressTime == 0 && this.shouldSearchForRecipes()) {
                    this.trySearchNewRecipe();
                }
            }
            if (this.wasActiveAndNeedsUpdate) {
                this.wasActiveAndNeedsUpdate = false;
                this.setActive(false);
            }
        }
    }

    @Override
    @Nullable
    public RecipeMap<?> getRecipeMap() {
        return this.recipeMap;
    }

    @Nullable
    public Recipe getPreviousRecipe() {
        return this.previousRecipe;
    }

    protected boolean shouldSearchForRecipes() {
        return this.canWorkWithInputs() && this.canFitNewOutputs();
    }

    protected boolean hasNotifiedInputs() {
        return !this.metaTileEntity.getNotifiedItemInputList().isEmpty() || !this.metaTileEntity.getNotifiedFluidInputList().isEmpty();
    }

    protected boolean hasNotifiedOutputs() {
        return !this.metaTileEntity.getNotifiedItemOutputList().isEmpty() || !this.metaTileEntity.getNotifiedFluidOutputList().isEmpty();
    }

    protected boolean canFitNewOutputs() {
        if (this.isOutputsFull && !this.hasNotifiedOutputs()) {
            return false;
        }
        this.isOutputsFull = false;
        this.metaTileEntity.getNotifiedItemOutputList().clear();
        this.metaTileEntity.getNotifiedFluidOutputList().clear();
        return true;
    }

    protected boolean canWorkWithInputs() {
        if (this.invalidInputsForRecipes && !this.hasNotifiedInputs()) {
            return false;
        }
        this.isOutputsFull = false;
        this.invalidInputsForRecipes = false;
        this.metaTileEntity.getNotifiedItemInputList().clear();
        this.metaTileEntity.getNotifiedFluidInputList().clear();
        return true;
    }

    @Override
    public void invalidateInputs() {
        this.invalidInputsForRecipes = true;
    }

    @Override
    public void invalidateOutputs() {
        this.isOutputsFull = true;
    }

    @Override
    public void setParallelRecipesPerformed(int amount) {
        this.parallelRecipesPerformed = amount;
    }

    public int getParallelRecipesPerformed() {
        return this.parallelRecipesPerformed;
    }

    protected void updateRecipeProgress() {
        if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
            this.drawEnergy(this.recipeEUt, false);
            if (++this.progressTime > this.maxProgressTime) {
                this.completeRecipe();
            }
            if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * this.recipeEUt) {
                this.hasNotEnoughEnergy = false;
            }
        } else if (this.recipeEUt > 0L) {
            this.hasNotEnoughEnergy = true;
            this.decreaseProgress();
        }
    }

    protected void decreaseProgress() {
        if (this.progressTime >= 2) {
            this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
        }
    }

    protected boolean canProgressRecipe() {
        if (this.previousRecipe == null) {
            return true;
        }
        return this.checkCleanroomRequirement(this.previousRecipe);
    }

    public void forceRecipeRecheck() {
        this.previousRecipe = null;
        this.trySearchNewRecipe();
    }

    protected void trySearchNewRecipe() {
        long maxVoltage = this.getMaxVoltage();
        IItemHandlerModifiable importInventory = this.getInputInventory();
        IMultipleTankHandler importFluids = this.getInputTank();
        Recipe currentRecipe = this.checkPreviousRecipe() ? this.previousRecipe : this.findRecipe(maxVoltage, importInventory, importFluids);
        if (currentRecipe != null) {
            this.previousRecipe = currentRecipe;
        }
        boolean bl = this.invalidInputsForRecipes = currentRecipe == null;
        if (currentRecipe != null && this.checkRecipe(currentRecipe)) {
            this.prepareRecipe(currentRecipe);
        }
    }

    protected boolean checkPreviousRecipe() {
        if (this.previousRecipe == null) {
            return false;
        }
        if (this.previousRecipe.getEUt() > this.getMaxVoltage()) {
            return false;
        }
        return this.previousRecipe.matches(false, this.getInputInventory(), this.getInputTank());
    }

    public boolean checkRecipe(@NotNull Recipe recipe) {
        return this.checkCleanroomRequirement(recipe) && this.checkDimensionRequirement(recipe);
    }

    protected boolean checkCleanroomRequirement(@NotNull Recipe recipe) {
        CleanroomType requiredType = recipe.getProperty(CleanroomProperty.getInstance(), null);
        if (requiredType == null) {
            return true;
        }
        MetaTileEntity mte = this.getMetaTileEntity();
        if (mte instanceof ICleanroomReceiver) {
            ICleanroomReceiver receiver = (ICleanroomReceiver)((Object)mte);
            if (ConfigHolder.machines.cleanMultiblocks && mte instanceof IMultiblockController) {
                return true;
            }
            ICleanroomProvider cleanroomProvider = receiver.getCleanroom();
            if (cleanroomProvider == null) {
                return false;
            }
            return cleanroomProvider.isClean() && cleanroomProvider.checkCleanroomType(requiredType);
        }
        return false;
    }

    protected boolean checkDimensionRequirement(@NotNull Recipe recipe) {
        DimensionProperty.DimensionPropertyList list = recipe.getProperty(DimensionProperty.getInstance(), null);
        if (list == null) {
            return true;
        }
        return list.checkDimension(this.getMetaTileEntity().getWorld().field_73011_w.getDimension());
    }

    public boolean prepareRecipe(Recipe recipe, IItemHandlerModifiable inputInventory, IMultipleTankHandler inputFluidInventory) {
        recipe = Recipe.trimRecipeOutputs(recipe, this.getRecipeMap(), this.metaTileEntity.getItemOutputLimit(), this.metaTileEntity.getFluidOutputLimit());
        if (this.euDiscount > 0.0 || this.speedBonus > 0.0) {
            RecipeBuilder builder = new RecipeBuilder(recipe, this.recipeMap);
            if (this.euDiscount > 0.0) {
                long newEUt = Math.round((double)recipe.getEUt() * this.euDiscount);
                if (newEUt <= 0L) {
                    newEUt = 1L;
                }
                builder.EUt(newEUt);
            }
            if (this.speedBonus > 0.0) {
                int duration = recipe.getDuration();
                int newDuration = (int)Math.round((double)duration * this.speedBonus);
                if (newDuration <= 0) {
                    newDuration = 1;
                }
                builder.duration(newDuration);
            }
            recipe = builder.build().getResult();
        }
        if ((recipe = this.findParallelRecipe(recipe, inputInventory, inputFluidInventory, this.getOutputInventory(), this.getOutputTank(), this.getMaxParallelVoltage(), this.getParallelLimit())) != null && (recipe = this.setupAndConsumeRecipeInputs(recipe, inputInventory, inputFluidInventory)) != null) {
            this.setupRecipe(recipe);
            return true;
        }
        return false;
    }

    public boolean prepareRecipe(Recipe recipe) {
        return this.prepareRecipe(recipe, this.getInputInventory(), this.getInputTank());
    }

    public int getParallelLimit() {
        return this.parallelLimit;
    }

    public void setParallelLimit(int amount) {
        this.parallelLimit = amount;
    }

    public void setEUDiscount(double discount) {
        if (discount <= 0.0) {
            GTLog.logger.warn("Cannot set EU discount for recipe logic to {}, discount must be > 0", (Object)discount);
            return;
        }
        this.euDiscount = discount;
    }

    public double getEUtDiscount() {
        return this.euDiscount;
    }

    public void setSpeedBonus(double bonus) {
        if (bonus <= 0.0) {
            GTLog.logger.warn("Cannot set speed bonus for recipe logic to {}, bonus must be > 0", (Object)bonus);
            return;
        }
        this.speedBonus = bonus;
    }

    public double getSpeedBonus() {
        return this.speedBonus;
    }

    @Override
    @NotNull
    public ParallelLogicType getParallelLogicType() {
        return ParallelLogicType.MULTIPLY;
    }

    protected static int getMinTankCapacity(@NotNull IMultipleTankHandler tanks) {
        if (tanks.getTanks() == 0) {
            return 0;
        }
        int result = Integer.MAX_VALUE;
        for (IFluidTank iFluidTank : tanks.getFluidTanks()) {
            result = Math.min(iFluidTank.getCapacity(), result);
        }
        return result;
    }

    @Nullable
    protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        RecipeMap<?> map = this.getRecipeMap();
        if (map == null || !this.isRecipeMapValid(map)) {
            return null;
        }
        return map.findRecipe(maxVoltage, inputs, fluidInputs);
    }

    public boolean isRecipeMapValid(@NotNull RecipeMap<?> recipeMap) {
        return true;
    }

    protected static boolean areItemStacksEqual(@NotNull ItemStack stackA, @NotNull ItemStack stackB) {
        return stackA.func_190926_b() && stackB.func_190926_b() || ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    @MustBeInvokedByOverriders
    @Nullable
    protected Recipe setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory) {
        return this.setupAndConsumeRecipeInputs(recipe, importInventory, this.getInputTank());
    }

    @Nullable
    protected final Recipe setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory, @NotNull IMultipleTankHandler importFluids) {
        this.calculateOverclock(recipe);
        this.modifyOverclockPost(this.ocResult, recipe.propertyStorage());
        if (this.ocResult.parallel() > 1 && (recipe = this.subTickOC(this.ocResult, recipe, importInventory, importFluids)) == null) {
            this.invalidateInputs();
            return null;
        }
        if (!this.hasEnoughPower(this.ocResult.eut(), this.ocResult.duration())) {
            this.ocResult.reset();
            return null;
        }
        if (this.checkOutputSpaceItems(recipe, this.getOutputInventory()) && this.checkOutputSpaceFluids(recipe, this.getOutputTank())) {
            this.isOutputsFull = false;
            if (recipe.matches(true, importInventory, importFluids)) {
                this.metaTileEntity.addNotifiedInput(importInventory);
                return recipe;
            }
        }
        return null;
    }

    protected boolean checkOutputSpaceItems(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable exportInventory) {
        if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)exportInventory, true, recipe.getAllItemOutputs())) {
            this.isOutputsFull = true;
            return false;
        }
        return true;
    }

    protected boolean checkOutputSpaceFluids(@NotNull Recipe recipe, @NotNull IMultipleTankHandler exportFluids) {
        if (!this.metaTileEntity.canVoidRecipeFluidOutputs() && !GTTransferUtils.addFluidsToFluidHandler(exportFluids, true, recipe.getAllFluidOutputs())) {
            this.isOutputsFull = true;
            return false;
        }
        return true;
    }

    @Nullable
    protected Recipe subTickOC(@NotNull OCResult ocResult, @NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory, @NotNull IMultipleTankHandler importFluids) {
        RecipeMap<?> map = this.getRecipeMap();
        if (map == null) {
            return null;
        }
        Recipe r = ((RecipeBuilder)new RecipeBuilder(recipe, map).EUt(ocResult.eut())).build().getResult();
        if (r == null) {
            return recipe;
        }
        RecipeBuilder<?> builder = this.findMultipliedParallelRecipe(map, r, importInventory, importFluids, this.getOutputInventory(), this.getOutputTank(), ocResult.parallel(), ocResult.parallelEUt(), this.getMetaTileEntity());
        if (builder == null) {
            return null;
        }
        if (builder.getParallel() == 0) {
            return recipe;
        }
        ocResult.setEut(builder.getEUt());
        r = ((RecipeBuilder)builder.EUt(builder.getEUt())).build().getResult();
        if (r == null) {
            return recipe;
        }
        return r;
    }

    protected boolean hasEnoughPower(long eut, int duration) {
        if (eut >= 0L) {
            return this.getEnergyStored() >= eut << 3;
        }
        return this.getEnergyStored() - eut <= this.getEnergyCapacity();
    }

    protected void modifyOverclockPost(@NotNull OCResult ocResult, @NotNull RecipePropertyStorage storage) {
    }

    protected final void calculateOverclock(@NotNull Recipe recipe) {
        this.ocParams.initialize(recipe.getEUt(), recipe.getDuration(), this.getNumberOfOCs(recipe.getEUt()));
        this.performOverclocking(recipe, this.ocParams, this.ocResult);
        this.ocParams.reset();
    }

    protected void performOverclocking(@NotNull Recipe recipe, @NotNull OCParams ocParams, @NotNull OCResult ocResult) {
        this.modifyOverclockPre(ocParams, recipe.propertyStorage());
        if (ocParams.ocAmount() <= 0) {
            ocResult.init(ocParams.eut(), ocParams.duration());
        } else {
            this.runOverclockingLogic(ocParams, ocResult, recipe.propertyStorage(), this.getMaximumOverclockVoltage());
        }
    }

    protected int getNumberOfOCs(long recipeEUt) {
        if (!this.isAllowOverclocking()) {
            return 0;
        }
        byte recipeTier = GTUtility.getOCTierByVoltage(recipeEUt);
        int maximumTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        if (maximumTier <= 1) {
            return 0;
        }
        int numberOfOCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --numberOfOCs;
        }
        return numberOfOCs;
    }

    protected void modifyOverclockPre(@NotNull OCParams ocParams, @NotNull RecipePropertyStorage storage) {
    }

    protected void runOverclockingLogic(@NotNull OCParams ocParams, @NotNull OCResult ocResult, @NotNull RecipePropertyStorage propertyStorage, long maxVoltage) {
        OverclockingLogic.standardOC(ocParams, ocResult, maxVoltage, this.getOverclockingDurationFactor(), this.getOverclockingVoltageFactor());
    }

    protected double getOverclockingDurationFactor() {
        return this.hasPerfectOC ? 0.25 : 0.5;
    }

    protected double getOverclockingVoltageFactor() {
        return 4.0;
    }

    protected int getOverclockForTier(long voltage) {
        return GTUtility.getOCTierByVoltage(voltage);
    }

    @MustBeInvokedByOverriders
    protected void setupRecipe(@NotNull Recipe recipe) {
        this.progressTime = 1;
        this.setMaxProgress(this.ocResult.duration());
        this.recipeEUt = this.ocResult.eut();
        byte recipeTier = GTUtility.getTierByVoltage(recipe.getEUt());
        int machineTier = this.getOverclockForTier(this.getMaximumOverclockVoltage());
        RecipeMap<?> map = this.getRecipeMap();
        if (map != null) {
            this.fluidOutputs = GTUtility.copyFluidList(recipe.getResultFluidOutputs(recipeTier, machineTier, map));
            this.itemOutputs = GTUtility.copyStackList(recipe.getResultItemOutputs(recipeTier, machineTier, map));
        }
        if (this.wasActiveAndNeedsUpdate) {
            this.wasActiveAndNeedsUpdate = false;
        } else {
            this.setActive(true);
        }
    }

    protected void completeRecipe() {
        this.outputRecipeOutputs();
        this.progressTime = 0;
        this.setMaxProgress(0);
        this.recipeEUt = 0L;
        this.fluidOutputs = Collections.emptyList();
        this.itemOutputs = Collections.emptyList();
        this.hasNotEnoughEnergy = false;
        this.wasActiveAndNeedsUpdate = true;
        this.parallelRecipesPerformed = 0;
        this.ocResult.reset();
    }

    protected void outputRecipeOutputs() {
        GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), false, this.itemOutputs);
        GTTransferUtils.addFluidsToFluidHandler(this.getOutputTank(), false, this.fluidOutputs);
    }

    public double getProgressPercent() {
        return this.getMaxProgress() == 0 ? 0.0 : (double)this.getProgress() / ((double)this.getMaxProgress() * 1.0);
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgressTime;
    }

    public long getRecipeEUt() {
        return this.recipeEUt;
    }

    public long getInfoProviderEUt() {
        return this.getRecipeEUt();
    }

    public int getPreviousRecipeDuration() {
        return this.getPreviousRecipe() == null ? 0 : this.getPreviousRecipe().getDuration();
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgressTime = maxProgress;
        this.metaTileEntity.markDirty();
    }

    protected void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.metaTileEntity.markDirty();
            World world = this.metaTileEntity.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        this.metaTileEntity.markDirty();
        World world = this.metaTileEntity.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    public boolean isHasNotEnoughEnergy() {
        return this.hasNotEnoughEnergy;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean isWorking() {
        return this.isActive && !this.hasNotEnoughEnergy && this.workingEnabled;
    }

    public void setAllowOverclocking(boolean allowOverclocking) {
        this.allowOverclocking = allowOverclocking;
        this.overclockVoltage = allowOverclocking ? this.getMaximumOverclockVoltage() : GTValues.V[0];
        this.metaTileEntity.markDirty();
    }

    public boolean isAllowOverclocking() {
        return this.allowOverclocking;
    }

    public void setMaximumOverclockVoltage(long overclockVoltage) {
        this.overclockVoltage = overclockVoltage;
        this.allowOverclocking = overclockVoltage > GTValues.V[1];
    }

    public long getMaximumOverclockVoltage() {
        return this.overclockVoltage;
    }

    @MustBeInvokedByOverriders
    public void invalidate() {
        this.previousRecipe = null;
        this.progressTime = 0;
        this.maxProgressTime = 0;
        this.recipeEUt = 0L;
        this.fluidOutputs = Collections.emptyList();
        this.itemOutputs = Collections.emptyList();
        this.parallelRecipesPerformed = 0;
        this.isOutputsFull = false;
        this.invalidInputsForRecipes = false;
        this.ocResult.reset();
        this.setActive(false);
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.getMetaTileEntity().scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
            this.getMetaTileEntity().scheduleRenderUpdate();
        }
    }

    @Override
    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.isActive = buf.readBoolean();
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("WorkEnabled", this.workingEnabled);
        compound.func_74757_a("CanRecipeProgress", this.canRecipeProgress);
        compound.func_74757_a(ALLOW_OVERCLOCKING, this.allowOverclocking);
        compound.func_74772_a(OVERCLOCK_VOLTAGE, this.overclockVoltage);
        if (this.progressTime > 0) {
            compound.func_74768_a("Progress", this.progressTime);
            compound.func_74768_a("MaxProgress", this.maxProgressTime);
            compound.func_74772_a("RecipeEUt", this.recipeEUt);
            NBTTagList itemOutputsList = new NBTTagList();
            for (ItemStack itemOutput : this.itemOutputs) {
                itemOutputsList.func_74742_a((NBTBase)itemOutput.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList fluidOutputsList = new NBTTagList();
            for (FluidStack fluidOutput : this.fluidOutputs) {
                fluidOutputsList.func_74742_a((NBTBase)fluidOutput.writeToNBT(new NBTTagCompound()));
            }
            compound.func_74782_a("ItemOutputs", (NBTBase)itemOutputsList);
            compound.func_74782_a("FluidOutputs", (NBTBase)fluidOutputsList);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        this.workingEnabled = compound.func_74767_n("WorkEnabled");
        this.canRecipeProgress = compound.func_74767_n("CanRecipeProgress");
        this.progressTime = compound.func_74762_e("Progress");
        this.allowOverclocking = compound.func_74767_n(ALLOW_OVERCLOCKING);
        this.overclockVoltage = compound.func_74763_f(OVERCLOCK_VOLTAGE);
        this.isActive = false;
        if (this.progressTime > 0) {
            this.isActive = true;
            this.maxProgressTime = compound.func_74762_e("MaxProgress");
            this.recipeEUt = Math.abs(compound.func_74763_f("RecipeEUt"));
            NBTTagList itemOutputsList = compound.func_150295_c("ItemOutputs", 10);
            this.itemOutputs = new ArrayList<ItemStack>(itemOutputsList.func_74745_c());
            for (int i = 0; i < itemOutputsList.func_74745_c(); ++i) {
                this.itemOutputs.add(new ItemStack(itemOutputsList.func_150305_b(i)));
            }
            NBTTagList fluidOutputsList = compound.func_150295_c("FluidOutputs", 10);
            this.fluidOutputs = new ArrayList<FluidStack>(fluidOutputsList.func_74745_c());
            for (int i = 0; i < fluidOutputsList.func_74745_c(); ++i) {
                this.fluidOutputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidOutputsList.func_150305_b(i)));
            }
        }
    }
}

