/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IQuantumController;
import gregtech.api.cover.CoverableView;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.Nullable;

public interface IQuantumStorage<T>
extends CoverableView {
    public Type getType();

    public void setConnected(IQuantumController var1);

    public void setDisconnected();

    public BlockPos getControllerPos();

    @Nullable
    public IQuantumController getQuantumController();

    @Override
    public BlockPos getPos();

    default public boolean isConnected() {
        return this.getControllerPos() != null;
    }

    default public void tryFindNetwork() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IQuantumController quantumController;
            TileEntity tileEntity;
            BlockPos offset = this.getPos().func_177972_a(facing);
            IBlockState state = this.getWorld().func_180495_p(offset);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.getWorld(), offset) || !((tileEntity = this.getNeighbor(facing)) instanceof IGregTechTileEntity)) continue;
            IGregTechTileEntity gtte = (IGregTechTileEntity)tileEntity;
            MetaTileEntity mte = gtte.getMetaTileEntity();
            IQuantumController candidate = null;
            if (mte instanceof IQuantumStorage) {
                IQuantumController controller;
                IQuantumStorage storage = (IQuantumStorage)((Object)mte);
                if (storage.isConnected() && (controller = storage.getQuantumController()) != null && controller.canConnect(this)) {
                    candidate = controller;
                }
            } else if (mte instanceof IQuantumController && (quantumController = (IQuantumController)((Object)mte)).canConnect(this)) {
                candidate = quantumController;
            }
            if (candidate == null) continue;
            candidate.rebuildNetwork();
            return;
        }
    }

    public T getTypeValue();

    public static enum Type {
        ITEM,
        FLUID,
        EXTENDER,
        PROXY,
        ENERGY;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }
}

