/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IFilter;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.AttributedFluid;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.client.utils.TooltipHelper;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public interface IPropertyFluidFilter<R>
extends IFilter<FluidStack> {
    @Override
    default public boolean test(@NotNull FluidStack stack) {
        Fluid fluid = stack.getFluid();
        if (fluid.getTemperature() < 120 && !this.isCryoProof()) {
            return false;
        }
        if (fluid instanceof AttributedFluid) {
            AttributedFluid attributedFluid = (AttributedFluid)fluid;
            FluidState state = attributedFluid.getState();
            if (!this.canContain(state)) {
                return false;
            }
            for (FluidAttribute attribute : attributedFluid.getAttributes()) {
                if (this.canContain(attribute)) continue;
                return false;
            }
            if (state == FluidState.PLASMA) {
                return true;
            }
        } else {
            if (fluid.isGaseous() && !this.canContain(FluidState.GAS)) {
                return false;
            }
            if (!this.canContain(FluidState.LIQUID)) {
                return false;
            }
        }
        return fluid.getTemperature() <= this.getMaxFluidTemperature();
    }

    @Override
    default public int getPriority() {
        return IFilter.blacklistLikePriority();
    }

    public boolean canContain(@NotNull FluidState var1);

    public boolean canContain(@NotNull FluidAttribute var1);

    public R setCanContain(@NotNull FluidAttribute var1, boolean var2);

    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes();

    default public void appendTooltips(@NotNull List<String> tooltip, boolean showToolsInfo, boolean showTemperatureInfo) {
        if (TooltipHelper.isShiftDown()) {
            if (showTemperatureInfo) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.max_temperature", (Object[])new Object[]{this.getMaxFluidTemperature()}));
            }
            if (this.isGasProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.gas_proof", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.not_gas_proof", (Object[])new Object[0]));
            }
            if (this.isPlasmaProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.plasma_proof", (Object[])new Object[0]));
            }
            if (this.isCryoProof()) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.fluid_pipe.cryo_proof", (Object[])new Object[0]));
            }
            this.getContainedAttributes().forEach(a -> a.appendContainerTooltips(tooltip));
        } else if (this.isGasProof() || this.isCryoProof() || this.isPlasmaProof() || !this.getContainedAttributes().isEmpty()) {
            if (showToolsInfo) {
                tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.tool_fluid_hold_shift", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.fluid_pipe_hold_shift", (Object[])new Object[0]));
            }
        }
    }

    public int getMaxFluidTemperature();

    public boolean isGasProof();

    public boolean isCryoProof();

    public boolean isPlasmaProof();
}

