/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IFilter;
import gregtech.api.capability.IFilteredFluidContainer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMultipleTankHandler
extends IFluidHandler,
Iterable<ITankEntry> {
    public static final Comparator<ITankEntry> ENTRY_COMPARATOR = (o1, o2) -> {
        boolean empty2;
        boolean empty1 = o1.getFluidAmount() <= 0;
        boolean bl = empty2 = o2.getFluidAmount() <= 0;
        if (empty1 != empty2) {
            return empty1 ? 1 : -1;
        }
        IFilter<FluidStack> filter1 = o1.getFilter();
        IFilter<FluidStack> filter2 = o2.getFilter();
        if (filter1 == null) {
            return filter2 == null ? 0 : 1;
        }
        if (filter2 == null) {
            return -1;
        }
        return IFilter.FILTER_COMPARATOR.compare(filter1, filter2);
    };

    @NotNull
    public List<ITankEntry> getFluidTanks();

    public int getTanks();

    @NotNull
    public ITankEntry getTankAt(int var1);

    public boolean allowSameFluidFill();

    default public int getIndexOfFluid(@Nullable FluidStack fluidStack) {
        List<ITankEntry> fluidTanks = this.getFluidTanks();
        for (int i = 0; i < fluidTanks.size(); ++i) {
            FluidStack tankStack = fluidTanks.get(i).getFluid();
            if (fluidStack != tankStack && (tankStack == null || !tankStack.isFluidEqual(fluidStack))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Iterator<ITankEntry> iterator() {
        return this.getFluidTanks().iterator();
    }

    public static interface ITankEntry
    extends IFluidTank,
    IFluidHandler,
    IFilteredFluidContainer,
    INBTSerializable<NBTTagCompound> {
        @NotNull
        public IMultipleTankHandler getParent();

        @NotNull
        public IFluidTank getDelegate();

        default public boolean allowSameFluidFill() {
            return this.getParent().allowSameFluidFill();
        }

        @Override
        default public IFilter<FluidStack> getFilter() {
            IFilter<FluidStack> iFilter;
            IFluidTank iFluidTank = this.getDelegate();
            if (iFluidTank instanceof IFilteredFluidContainer) {
                IFilteredFluidContainer filtered = (IFilteredFluidContainer)iFluidTank;
                iFilter = filtered.getFilter();
            } else {
                iFilter = null;
            }
            return iFilter;
        }

        default public NBTTagCompound serializeNBT() {
            INBTSerializable serializable;
            NBTBase nBTBase;
            IFluidTank iFluidTank = this.getDelegate();
            if (iFluidTank instanceof FluidTank) {
                FluidTank fluidTank = (FluidTank)iFluidTank;
                return fluidTank.writeToNBT(new NBTTagCompound());
            }
            iFluidTank = this.getDelegate();
            if (iFluidTank instanceof INBTSerializable && (nBTBase = (serializable = (INBTSerializable)iFluidTank).serializeNBT()) instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)nBTBase;
                return compound;
            }
            return new NBTTagCompound();
        }

        default public void deserializeNBT(NBTTagCompound nbt) {
            IFluidTank iFluidTank = this.getDelegate();
            if (iFluidTank instanceof FluidTank) {
                FluidTank fluidTank = (FluidTank)iFluidTank;
                fluidTank.readFromNBT(nbt);
            } else {
                iFluidTank = this.getDelegate();
                if (iFluidTank instanceof INBTSerializable) {
                    INBTSerializable serializable = (INBTSerializable)iFluidTank;
                    try {
                        serializable.deserializeNBT((NBTBase)nbt);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }

        @Nullable
        default public FluidStack getFluid() {
            return this.getDelegate().getFluid();
        }

        default public int getFluidAmount() {
            return this.getDelegate().getFluidAmount();
        }

        default public int getCapacity() {
            return this.getDelegate().getCapacity();
        }

        default public FluidTankInfo getInfo() {
            return this.getDelegate().getInfo();
        }
    }
}

