/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.util.ItemStackHashStrategy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class DualHandler
implements IItemHandlerModifiable,
IMultipleTankHandler,
INotifiableHandler {
    @NotNull
    private static final ItemStackHashStrategy strategy = ItemStackHashStrategy.comparingAll();
    @NotNull
    protected IItemHandlerModifiable itemDelegate;
    @NotNull
    protected IMultipleTankHandler fluidDelegate;
    private final List<IMultipleTankHandler.ITankEntry> unwrapped;
    List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
    private final boolean isExport;

    public DualHandler(@NotNull IItemHandlerModifiable itemDelegate, @NotNull IMultipleTankHandler fluidDelegate, boolean isExport) {
        this.itemDelegate = itemDelegate;
        this.fluidDelegate = fluidDelegate;
        this.isExport = isExport;
        ArrayList<IMultipleTankHandler.ITankEntry> list = new ArrayList<IMultipleTankHandler.ITankEntry>();
        for (IMultipleTankHandler.ITankEntry tank : this.fluidDelegate) {
            list.add(this.wrap(tank));
        }
        this.unwrapped = list;
    }

    public DualHandler(@NotNull IItemHandlerModifiable itemDelegate, @NotNull IFluidTank fluidTank, boolean isExport) {
        this(itemDelegate, new FluidTankList(false, fluidTank), isExport);
    }

    private DualEntry wrap(IMultipleTankHandler.ITankEntry entry) {
        return entry instanceof DualEntry ? (DualEntry)entry : new DualEntry(this, entry);
    }

    public boolean isExport() {
        return this.isExport;
    }

    public int getSlots() {
        return this.itemDelegate.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.itemDelegate.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack remainder = this.itemDelegate.insertItem(slot, stack, simulate);
        if (!simulate && !strategy.equals(remainder, stack)) {
            this.onContentsChanged();
        }
        return remainder;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = this.itemDelegate.extractItem(slot, amount, simulate);
        if (!simulate && !extracted.func_190926_b()) {
            this.onContentsChanged();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return this.itemDelegate.getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStack oldStack = this.itemDelegate.getStackInSlot(slot);
        this.itemDelegate.setStackInSlot(slot, stack);
        if (!strategy.equals(oldStack, stack)) {
            this.onContentsChanged();
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.fluidDelegate.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        int filled = this.fluidDelegate.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack drained = this.fluidDelegate.drain(resource, doDrain);
        if (doDrain && drained != null) {
            this.onContentsChanged();
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = this.fluidDelegate.drain(maxDrain, doDrain);
        if (doDrain && drained != null) {
            this.onContentsChanged();
        }
        return drained;
    }

    @Override
    @NotNull
    public List<IMultipleTankHandler.ITankEntry> getFluidTanks() {
        return this.unwrapped;
    }

    @Override
    public int getTanks() {
        return this.fluidDelegate.getTanks();
    }

    @Override
    @NotNull
    public IMultipleTankHandler.ITankEntry getTankAt(int index) {
        return this.unwrapped.get(index);
    }

    @Override
    public boolean allowSameFluidFill() {
        return this.fluidDelegate.allowSameFluidFill();
    }

    public void onContentsChanged(Object handler) {
        for (MetaTileEntity metaTileEntity : this.notifiableEntities) {
            this.addToNotifiedList(metaTileEntity, handler, this.isExport);
        }
    }

    public void onContentsChanged() {
        this.onContentsChanged(this);
    }

    @Override
    public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        if (metaTileEntity == null || this.notifiableEntities.contains(metaTileEntity)) {
            return;
        }
        this.notifiableEntities.add(metaTileEntity);
    }

    @Override
    public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.notifiableEntities.remove(metaTileEntity);
    }

    @NotNull
    public IItemHandlerModifiable getItemDelegate() {
        return this.itemDelegate;
    }

    @NotNull
    public IMultipleTankHandler getFluidDelegate() {
        return this.fluidDelegate;
    }

    public static class DualEntry
    implements IMultipleTankHandler.ITankEntry,
    INotifiableHandler {
        @NotNull
        private final DualHandler tank;
        @NotNull
        private final IMultipleTankHandler.ITankEntry delegate;

        public DualEntry(@NotNull DualHandler tank, @NotNull IMultipleTankHandler.ITankEntry delegate) {
            this.delegate = delegate;
            this.tank = tank;
        }

        @Override
        @NotNull
        public IMultipleTankHandler getParent() {
            return this.tank;
        }

        @Override
        @NotNull
        public IMultipleTankHandler.ITankEntry getDelegate() {
            return this.delegate;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.getDelegate().getTankProperties();
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = this.getDelegate().fill(resource, doFill);
            if (doFill && filled > 0) {
                this.tank.onContentsChanged(this);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack drained = this.getDelegate().drain(resource, doDrain);
            if (doDrain && drained != null) {
                this.tank.onContentsChanged(this);
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack drained = this.getDelegate().drain(maxDrain, doDrain);
            if (doDrain && drained != null) {
                this.tank.onContentsChanged(this);
            }
            return drained;
        }

        @Override
        public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.tank.addNotifiableMetaTileEntity(metaTileEntity);
        }

        @Override
        public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.tank.removeNotifiableMetaTileEntity(metaTileEntity);
        }
    }
}

