/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block.machines;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.Cuboid6;
import gregtech.api.GregTechAPI;
import gregtech.api.block.BlockCustomParticle;
import gregtech.api.block.UnlistedIntegerProperty;
import gregtech.api.block.UnlistedStringProperty;
import gregtech.api.cover.Cover;
import gregtech.api.cover.IFacadeCover;
import gregtech.api.items.toolitem.ToolHelper;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.registry.MTERegistry;
import gregtech.api.pipenet.IBlockAppearance;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Mods;
import gregtech.client.renderer.handler.MetaTileEntityRenderer;
import gregtech.common.creativetab.GTCreativeTabs;
import gregtech.common.items.MetaItems;
import gregtech.integration.ctm.IFacadeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockMachine
extends BlockCustomParticle
implements ITileEntityProvider,
IFacadeWrapper,
IBlockAppearance {
    private static final List<IndexedCuboid6> EMPTY_COLLISION_BOX = Collections.emptyList();
    public static final PropertyBool OPAQUE = PropertyBool.func_177716_a((String)"opaque");
    private static final IUnlistedProperty<String> HARVEST_TOOL = new UnlistedStringProperty("harvest_tool");
    private static final IUnlistedProperty<Integer> HARVEST_LEVEL = new UnlistedIntegerProperty("harvest_level");
    protected final ThreadLocal<MetaTileEntity> tileEntities = new ThreadLocal();

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH_MACHINES);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(6.0f);
        this.func_149752_b(6.0f);
        this.func_149663_c("unnamed");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)OPAQUE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public String getHarvestTool(@NotNull IBlockState state) {
        String value = (String)((IExtendedBlockState)state).getValue(HARVEST_TOOL);
        return value == null ? "wrench" : value;
    }

    public int getHarvestLevel(@NotNull IBlockState state) {
        Integer value = (Integer)((IExtendedBlockState)state).getValue(HARVEST_LEVEL);
        return value == null ? 1 : value;
    }

    public boolean func_176214_u(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(worldIn, pos);
        if (metaTileEntity == null) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty(HARVEST_TOOL, (Object)metaTileEntity.getHarvestTool()).withProperty(HARVEST_LEVEL, (Object)metaTileEntity.getHarvestLevel());
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{OPAQUE}, new IUnlistedProperty[]{HARVEST_TOOL, HARVEST_LEVEL});
    }

    public float func_180647_a(@NotNull IBlockState state, @NotNull EntityPlayer player, @NotNull World worldIn, @NotNull BlockPos pos) {
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)worldIn, pos);
        return super.func_180647_a(state, player, worldIn, pos);
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)OPAQUE, (Comparable)Boolean.valueOf(meta % 2 == 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE) != false ? 0 : 1;
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public float func_176195_g(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)worldIn, pos);
        return metaTileEntity == null ? 1.0f : metaTileEntity.getBlockHardness();
    }

    public float getExplosionResistance(@NotNull World world, @NotNull BlockPos pos, @Nullable Entity exploder, @NotNull Explosion explosion) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        return metaTileEntity == null ? 1.0f : metaTileEntity.getBlockResistance();
    }

    private static List<IndexedCuboid6> getCollisionBox(IBlockAccess blockAccess, BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(blockAccess, pos);
        if (metaTileEntity == null) {
            return EMPTY_COLLISION_BOX;
        }
        ArrayList<IndexedCuboid6> collisionList = new ArrayList<IndexedCuboid6>();
        metaTileEntity.addCollisionBoundingBox(collisionList);
        metaTileEntity.addCoverCollisionBoundingBox(collisionList);
        return collisionList;
    }

    public boolean doesSideBlockRendering(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        return state.func_185914_p() && GTUtility.getMetaTileEntity(world, pos) != null;
    }

    @NotNull
    public ItemStack getPickBlock(@NotNull IBlockState state, @NotNull RayTraceResult target, @NotNull World world, @NotNull BlockPos pos, @NotNull EntityPlayer player) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null) {
            return ItemStack.field_190927_a;
        }
        if (target instanceof CuboidRayTraceResult) {
            return metaTileEntity.getPickItem((CuboidRayTraceResult)target, player);
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack func_185473_a(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState state) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null) {
            return ItemStack.field_190927_a;
        }
        return metaTileEntity.getStackForm();
    }

    public void func_185477_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull AxisAlignedBB entityBox, @NotNull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        for (Cuboid6 cuboid6 : BlockMachine.getCollisionBox((IBlockAccess)worldIn, pos)) {
            AxisAlignedBB offsetBox = cuboid6.aabb().func_186670_a(pos);
            if (!offsetBox.func_72326_a(entityBox)) continue;
            collidingBoxes.add(offsetBox);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(@NotNull IBlockState blockState, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Vec3d start, @NotNull Vec3d end) {
        return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, BlockMachine.getCollisionBox((IBlockAccess)worldIn, pos));
    }

    public boolean rotateBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing axis) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null) {
            return false;
        }
        if (metaTileEntity.hasFrontFacing() && metaTileEntity.isValidFrontFacing(axis)) {
            metaTileEntity.setFrontFacing(axis);
            return true;
        }
        return false;
    }

    @Nullable
    public EnumFacing[] getValidRotations(@NotNull World world, @NotNull BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null || !metaTileEntity.hasFrontFacing()) {
            return null;
        }
        return (EnumFacing[])Arrays.stream(EnumFacing.field_82609_l).filter(metaTileEntity::isValidFrontFacing).toArray(EnumFacing[]::new);
    }

    public boolean recolorBlock(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing side, @NotNull EnumDyeColor color) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)world, pos);
        if (metaTileEntity == null || metaTileEntity.getPaintingColor() == color.field_193351_w) {
            return false;
        }
        metaTileEntity.setPaintingColor(color.field_193351_w);
        return true;
    }

    public void func_180633_a(World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityLivingBase placer, ItemStack stack) {
        IGregTechTileEntity holder = (IGregTechTileEntity)worldIn.func_175625_s(pos);
        MTERegistry registry = GregTechAPI.mteManager.getRegistry(Objects.requireNonNull(stack.func_77973_b().getRegistryName()).func_110624_b());
        MetaTileEntity sampleMetaTileEntity = (MetaTileEntity)registry.func_148754_a(stack.func_77952_i());
        if (holder == null || sampleMetaTileEntity == null) {
            return;
        }
        if (stack.func_82837_s() && holder instanceof MetaTileEntityHolder) {
            ((MetaTileEntityHolder)holder).setCustomName(stack.func_82833_r());
        }
        NBTTagCompound stackTag = stack.func_77978_p();
        NBTTagCompound mteTag = null;
        if (stackTag != null && !stackTag.func_82582_d() && stackTag.func_74764_b("BlockEntityTag")) {
            NBTTagCompound blockTag = stackTag.func_74775_l("BlockEntityTag");
            String customName = blockTag.func_74779_i("CustomName");
            if (!customName.isEmpty()) {
                ((MetaTileEntityHolder)holder).setCustomName(customName);
            }
            mteTag = blockTag.func_74775_l("MetaTileEntity");
            ArrayList<String> removed = new ArrayList<String>();
            for (String key : mteTag.func_150296_c()) {
                MTETrait trait = sampleMetaTileEntity.getMTETrait(key);
                if (trait == null) continue;
                removed.add(key);
            }
            removed.forEach(arg_0 -> ((NBTTagCompound)mteTag).func_82580_o(arg_0));
        }
        MetaTileEntity metaTileEntity = holder.setMetaTileEntity(sampleMetaTileEntity, mteTag);
        if (mteTag == null) {
            MultiblockControllerBase multi;
            if (stackTag != null && !stackTag.func_82582_d()) {
                metaTileEntity.initFromItemStackData(stackTag);
            }
            if (metaTileEntity.isValidFrontFacing(EnumFacing.UP)) {
                metaTileEntity.setFrontFacing(EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
            } else {
                metaTileEntity.setFrontFacing(placer.func_174811_aO().func_176734_d());
            }
            if (metaTileEntity instanceof MultiblockControllerBase && (multi = (MultiblockControllerBase)metaTileEntity).allowsExtendedFacing()) {
                EnumFacing frontFacing = multi.getFrontFacing();
                if (frontFacing == EnumFacing.UP) {
                    multi.setUpwardsFacing(placer.func_174811_aO());
                } else if (frontFacing == EnumFacing.DOWN) {
                    multi.setUpwardsFacing(placer.func_174811_aO().func_176734_d());
                }
            }
        }
        if (Mods.AppliedEnergistics2.isModLoaded() && metaTileEntity.getProxy() != null) {
            metaTileEntity.getProxy().setOwner((EntityPlayer)placer);
        }
        if (placer instanceof EntityPlayer) {
            ItemStack offhand = placer.func_184592_cb();
            for (int i = 0; i < EnumDyeColor.values().length; ++i) {
                if (!offhand.func_77969_a(MetaItems.SPRAY_CAN_DYES[i].getStackForm())) continue;
                MetaItems.SPRAY_CAN_DYES[i].getBehaviours().get(0).onItemUse((EntityPlayer)placer, worldIn, pos, EnumHand.OFF_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
                break;
            }
        }
        metaTileEntity.onPlacement(placer);
    }

    public void func_180663_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity != null) {
            if (!metaTileEntity.keepsInventory()) {
                ArrayList<ItemStack> inventoryContents = new ArrayList<ItemStack>();
                metaTileEntity.clearMachineInventory(inventoryContents);
                for (ItemStack itemStack : inventoryContents) {
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
            metaTileEntity.dropAllCovers();
            metaTileEntity.onRemoval();
            this.tileEntities.set(metaTileEntity);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        MetaTileEntityHolder holder;
        MetaTileEntity metaTileEntity;
        MetaTileEntity metaTileEntity2 = metaTileEntity = this.tileEntities.get() == null ? GTUtility.getMetaTileEntity(world, pos) : this.tileEntities.get();
        if (metaTileEntity == null) {
            return;
        }
        if (!metaTileEntity.shouldDropWhenDestroyed()) {
            return;
        }
        ItemStack itemStack = metaTileEntity.getStackForm();
        NBTTagCompound tagCompound = new NBTTagCompound();
        metaTileEntity.writeItemStackData(tagCompound);
        if (!tagCompound.func_82582_d()) {
            itemStack.func_77982_d(tagCompound);
        }
        if (metaTileEntity.getHolder() instanceof MetaTileEntityHolder && (holder = (MetaTileEntityHolder)metaTileEntity.getHolder()).func_145818_k_()) {
            itemStack.func_151001_c(holder.func_70005_c_());
        }
        drops.add((Object)itemStack);
        metaTileEntity.getDrops((List<ItemStack>)drops, (EntityPlayer)this.harvesters.get());
    }

    public boolean func_180639_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer playerIn, @NotNull EnumHand hand, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)worldIn, pos);
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (metaTileEntity == null || rayTraceResult == null) {
            return false;
        }
        Set toolClasses = itemStack.func_77973_b().getToolClasses(itemStack);
        if (!toolClasses.isEmpty() && metaTileEntity.onToolClick(playerIn, toolClasses, hand, rayTraceResult)) {
            ToolHelper.damageItem(itemStack, (EntityLivingBase)playerIn);
            ToolHelper.playToolSound(itemStack, playerIn);
            return true;
        }
        return metaTileEntity.onRightClick(playerIn, hand, facing, rayTraceResult);
    }

    public void func_180649_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull EntityPlayer playerIn) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity == null) {
            return;
        }
        CuboidRayTraceResult rayTraceResult = (CuboidRayTraceResult)RayTracer.retraceBlock((World)worldIn, (EntityPlayer)playerIn, (BlockPos)pos);
        if (rayTraceResult != null) {
            metaTileEntity.onCoverLeftClick(playerIn, rayTraceResult);
        }
    }

    public boolean canConnectRedstone(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable EnumFacing side) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        return metaTileEntity != null && metaTileEntity.canConnectRedstone(side == null ? null : side.func_176734_d());
    }

    public boolean shouldCheckWeakPower(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        return false;
    }

    public int func_180656_a(@NotNull IBlockState blockState, @NotNull IBlockAccess blockAccess, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(blockAccess, pos);
        return metaTileEntity == null ? 0 : metaTileEntity.getOutputRedstoneSignal(side == null ? null : side.func_176734_d());
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        TileEntity holder = worldIn.func_175625_s(pos);
        if (holder instanceof IGregTechTileEntity) {
            MetaTileEntity metaTileEntity;
            IGregTechTileEntity gregTechTile = (IGregTechTileEntity)holder;
            EnumFacing facing = GTUtility.getFacingToNeighbor(pos, fromPos);
            if (facing != null) {
                gregTechTile.onNeighborChanged(facing);
            }
            if ((metaTileEntity = gregTechTile.getMetaTileEntity()) != null) {
                metaTileEntity.updateInputRedstoneSignals();
                metaTileEntity.onNeighborChanged();
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, @NotNull BlockPos pos, @NotNull BlockPos neighbor) {
        TileEntity holder = world.func_175625_s(pos);
        if (holder instanceof IGregTechTileEntity) {
            IGregTechTileEntity gregTechTile = (IGregTechTileEntity)holder;
            EnumFacing facing = GTUtility.getFacingToNeighbor(pos, neighbor);
            if (facing != null) {
                gregTechTile.onNeighborChanged(facing);
            }
        }
    }

    public void func_180657_a(@NotNull World worldIn, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        this.tileEntities.set(te == null ? this.tileEntities.get() : ((IGregTechTileEntity)te).getMetaTileEntity());
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        this.tileEntities.remove();
    }

    @Nullable
    public TileEntity func_149915_a(@Nullable World worldIn, int meta) {
        return new MetaTileEntityHolder();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public EnumBlockRenderType func_149645_b(@NotNull IBlockState state) {
        return MetaTileEntityRenderer.BLOCK_RENDER_TYPE;
    }

    public boolean canRenderInLayer(@NotNull IBlockState state, @NotNull BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUE);
    }

    @NotNull
    public BlockFaceShape func_193383_a(@NotNull IBlockAccess worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(worldIn, pos);
        return metaTileEntity == null ? BlockFaceShape.SOLID : metaTileEntity.getCoverFaceShape(face);
    }

    public int getLightValue(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        return metaTileEntity == null ? 0 : metaTileEntity.getLightValue();
    }

    public int getLightOpacity(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        return metaTileEntity == null ? 255 : metaTileEntity.getLightOpacity();
    }

    public void func_149666_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        MTERegistry registry = GregTechAPI.mteManager.getRegistry(Objects.requireNonNull(this.getRegistryName()).func_110624_b());
        Iterator iterator = registry.iterator();
        while (iterator.hasNext()) {
            MetaTileEntity metaTileEntity = (MetaTileEntity)iterator.next();
            if (!metaTileEntity.isInCreativeTab(tab)) continue;
            metaTileEntity.getSubItems(tab, items);
        }
    }

    @Override
    @NotNull
    public IBlockState getFacade(@NotNull IBlockAccess world, @NotNull BlockPos pos, @Nullable EnumFacing side, @NotNull BlockPos otherPos) {
        return this.getFacade(world, pos, side);
    }

    @Override
    @NotNull
    public IBlockState getFacade(@NotNull IBlockAccess world, @NotNull BlockPos pos, EnumFacing side) {
        Cover cover;
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        if (metaTileEntity != null && side != null && (cover = metaTileEntity.getCoverAtSide(side)) instanceof IFacadeCover) {
            IFacadeCover facadeCover = (IFacadeCover)((Object)cover);
            return facadeCover.getVisualState();
        }
        return world.func_180495_p(pos);
    }

    @Override
    @NotNull
    public IBlockState getVisualState(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
        return this.getFacade(world, pos, side);
    }

    @Override
    public boolean supportsVisualConnections() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return MetaTileEntityRenderer.getParticleTexture((IBlockAccess)world, blockPos);
    }

    public boolean canEntityDestroy(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull Entity entity) {
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity(world, pos);
        if (metaTileEntity == null) {
            return super.canEntityDestroy(state, world, pos, entity);
        }
        return !(entity instanceof EntityWither) && !(entity instanceof EntityWitherSkull) || !metaTileEntity.getWitherProof();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(@NotNull IBlockState stateIn, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        MetaTileEntity metaTileEntity = GTUtility.getMetaTileEntity((IBlockAccess)worldIn, pos);
        if (metaTileEntity != null) {
            metaTileEntity.randomDisplayTick();
        }
    }
}

