/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.block;

import gregtech.api.block.IStateHarvestLevel;
import gregtech.api.util.LocalizationUtils;
import gregtech.common.creativetab.GTCreativeTabs;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantBlock<T extends Enum<T>>
extends Block {
    protected PropertyEnum<T> VARIANT;
    protected T[] VALUES;

    public VariantBlock(@NotNull Material materialIn) {
        super(materialIn);
        if (this.VALUES.length > 0 && this.VALUES[0] instanceof IStateHarvestLevel) {
            for (T t : this.VALUES) {
                IStateHarvestLevel stateHarvestLevel = (IStateHarvestLevel)t;
                IBlockState state = this.getState(t);
                this.setHarvestLevel(stateHarvestLevel.getHarvestTool(state), stateHarvestLevel.getHarvestLevel(state), state);
            }
        }
        this.func_149647_a(GTCreativeTabs.TAB_GREGTECH);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(this.VARIANT, this.VALUES[0]));
    }

    public void func_149666_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> list) {
        for (T variant : this.VALUES) {
            list.add((Object)this.getItemVariant(variant));
        }
    }

    public IBlockState getState(T variant) {
        return this.func_176223_P().func_177226_a(this.VARIANT, variant);
    }

    public T getState(IBlockState blockState) {
        return (T)((Enum)((Object)blockState.func_177229_b(this.VARIANT)));
    }

    public T getState(ItemStack stack) {
        return this.getState(this.func_176203_a(stack.func_77952_i()));
    }

    public ItemStack getItemVariant(T variant) {
        return this.getItemVariant(variant, 1);
    }

    public ItemStack getItemVariant(T variant, int amount) {
        return new ItemStack((Block)this, amount, ((Enum)variant).ordinal());
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        Class<T> enumClass = VariantBlock.getActualTypeParameter(((Object)((Object)this)).getClass(), VariantBlock.class);
        this.VARIANT = PropertyEnum.func_177709_a((String)"variant", enumClass);
        this.VALUES = (Enum[])enumClass.getEnumConstants();
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, @NotNull ITooltipFlag advanced) {
        String unlocalizedTooltip;
        String unlocalizedVariantTooltip = this.func_149739_a() + ".tooltip";
        if (I18n.func_188566_a((String)unlocalizedVariantTooltip)) {
            Collections.addAll(tooltip, LocalizationUtils.formatLines(unlocalizedVariantTooltip, new Object[0]));
        }
        if (I18n.func_188566_a((String)(unlocalizedTooltip = stack.func_77977_a() + ".tooltip"))) {
            Collections.addAll(tooltip, LocalizationUtils.formatLines(unlocalizedTooltip, new Object[0]));
        }
    }

    public int func_180651_a(@NotNull IBlockState state) {
        return this.func_176201_c(state);
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.VARIANT, this.VALUES[meta % this.VALUES.length]);
    }

    public int func_176201_c(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b(this.VARIANT))).ordinal();
    }

    protected static <T, R> Class<T> getActualTypeParameter(Class<? extends R> thisClass, Class<R> declaringClass) {
        Type type = thisClass.getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != declaringClass) {
            if (type instanceof ParameterizedType) {
                type = ((Class)((ParameterizedType)type).getRawType()).getGenericSuperclass();
                continue;
            }
            type = ((Class)type).getGenericSuperclass();
        }
        return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

