/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import gregtech.api.advancement.IAdvancementManager;
import gregtech.api.block.ICleanroomFilter;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.command.ICommandManager;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.event.HighTierEvent;
import gregtech.api.gui.UIFactory;
import gregtech.api.metatileentity.multiblock.IBatteryData;
import gregtech.api.metatileentity.registry.MTEManager;
import gregtech.api.modules.IModuleManager;
import gregtech.api.network.INetworkHandler;
import gregtech.api.recipes.properties.RecipePropertyRegistry;
import gregtech.api.sound.ISoundManager;
import gregtech.api.unification.RecyclingManager;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.registry.IMaterialRegistryManager;
import gregtech.api.unification.material.registry.MarkerMaterialRegistry;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.GTControlledRegistry;
import gregtech.api.util.GTLog;
import gregtech.api.util.IBlockOre;
import gregtech.common.ConfigHolder;
import gregtech.datafix.migration.lib.MigrationAPI;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.GenericEvent;

public class GregTechAPI {
    public static Object instance;
    public static IModuleManager moduleManager;
    public static INetworkHandler networkHandler;
    public static ICommandManager commandManager;
    public static IAdvancementManager advancementManager;
    public static ISoundManager soundManager;
    public static IMaterialRegistryManager materialManager;
    public static MarkerMaterialRegistry markerMaterialRegistry;
    public static MTEManager mteManager;
    public static final MigrationAPI MIGRATIONS;
    public static final RecipePropertyRegistry RECIPE_PROPERTIES;
    public static final RecyclingManager RECYCLING_MANAGER;
    private static boolean highTier;
    private static boolean highTierInitialized;
    @Deprecated
    public static final GTControlledRegistry<ResourceLocation, UIFactory> UI_FACTORY_REGISTRY;
    public static final GTControlledRegistry<ResourceLocation, CoverDefinition> COVER_REGISTRY;
    public static final Map<Material, Map<StoneType, IBlockOre>> oreBlockTable;
    public static final Object2ObjectMap<IBlockState, IHeatingCoilBlockStats> HEATING_COILS;
    public static final Object2ObjectMap<IBlockState, IBatteryData> PSS_BATTERIES;
    public static final Object2ObjectMap<IBlockState, ICleanroomFilter> CLEANROOM_FILTERS;

    public static boolean isHighTier() {
        return highTier;
    }

    static void initializeHighTier() {
        if (highTierInitialized) {
            throw new IllegalStateException("High-Tier is already initialized.");
        }
        HighTierEvent highTierEvent = new HighTierEvent();
        MinecraftForge.EVENT_BUS.post((Event)highTierEvent);
        highTier = ConfigHolder.machines.highTierContent || highTierEvent.isHighTier();
        highTierInitialized = true;
        if (GregTechAPI.isHighTier()) {
            GTLog.logger.info("High-Tier is Enabled.");
        } else {
            GTLog.logger.info("High-Tier is Disabled.");
        }
    }

    static {
        MIGRATIONS = new MigrationAPI();
        RECIPE_PROPERTIES = new RecipePropertyRegistry();
        RECYCLING_MANAGER = new RecyclingManager();
        UI_FACTORY_REGISTRY = new GTControlledRegistry(Short.MAX_VALUE);
        COVER_REGISTRY = new GTControlledRegistry(Integer.MAX_VALUE);
        oreBlockTable = new HashMap<Material, Map<StoneType, IBlockOre>>();
        HEATING_COILS = new Object2ObjectOpenHashMap();
        PSS_BATTERIES = new Object2ObjectOpenHashMap();
        CLEANROOM_FILTERS = new Object2ObjectOpenHashMap();
    }

    public static class RegisterEvent<V>
    extends GenericEvent<V> {
        private final GTControlledRegistry<ResourceLocation, V> registry;

        public RegisterEvent(GTControlledRegistry<ResourceLocation, V> registry, Class<V> clazz) {
            super(clazz);
            this.registry = registry;
        }

        public void register(int id, ResourceLocation key, V value) {
            if (this.registry != null) {
                this.registry.func_177775_a(id, key, value);
            }
        }

        public void register(int id, String key, V value) {
            if (this.registry != null) {
                this.registry.func_177775_a(id, new ResourceLocation(Loader.instance().activeModContainer().getModId(), key), value);
            }
        }
    }
}

