/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.google.common.collect.Lists;
import com.mrcrayfish.catalogue.Catalogue;
import com.mrcrayfish.catalogue.client.ScreenUtil;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueListExtended;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueTextField;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class CatalogueModListScreen
extends GuiScreen {
    private static final ResourceLocation MISSING_BANNER = new ResourceLocation("catalogue", "textures/gui/missing_banner.png");
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private static final Map<String, Pair<ResourceLocation, ScreenUtil.Size2i>> LOGO_CACHE = new HashMap<String, Pair<ResourceLocation, ScreenUtil.Size2i>>();
    private static final Map<String, Pair<ResourceLocation, ScreenUtil.Size2i>> ICON_CACHE = new HashMap<String, Pair<ResourceLocation, ScreenUtil.Size2i>>();
    private static final Map<String, ItemStack> ITEM_CACHE = new HashMap<String, ItemStack>();
    private CatalogueTextField searchTextField;
    private ModList modList;
    private ModContainer selectedModInfo;
    private CatalogueIconButton modFolderButton;
    private CatalogueIconButton configButton;
    private CatalogueIconButton websiteButton;
    private CatalogueIconButton issueButton;
    private CatalogueCheckBoxButton updatesButton;
    private List<String> activeTooltip;
    private int tooltipYOffset;
    private StringList descriptionList;
    private long lastClickTime;

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchTextField = new CatalogueTextField(0, this.field_146289_q, 11, 25, 148, 20);
        this.searchTextField.func_146205_d(true);
        this.searchTextField.func_146185_a(true);
        this.modList = new ModList();
        this.modList.func_148140_g(10);
        this.modList.setDrawTopAndBottom(false);
        this.field_146292_n.add(new GuiButton(1, 10, this.modList.field_148154_c + 8, 127, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.modFolderButton = (CatalogueIconButton)this.func_189646_b(new CatalogueIconButton(2, 140, this.modList.field_148154_c + 8, 0, 0));
        int padding = 10;
        int contentLeft = this.modList.field_148151_d + 12 + padding;
        int contentWidth = this.field_146294_l - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (CatalogueIconButton)this.func_189646_b(new CatalogueIconButton(3, contentLeft, 105, 10, 0, buttonWidth, I18n.func_135052_a((String)"catalogue.gui.config", (Object[])new Object[0])));
        this.configButton.field_146125_m = false;
        this.websiteButton = (CatalogueIconButton)this.func_189646_b(new CatalogueIconButton(4, contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, I18n.func_135052_a((String)"catalogue.gui.website", (Object[])new Object[0])));
        this.websiteButton.field_146125_m = false;
        this.issueButton = (CatalogueIconButton)this.func_189646_b(new CatalogueIconButton(5, contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, I18n.func_135052_a((String)"catalogue.gui.issue", (Object[])new Object[0])));
        this.issueButton.field_146125_m = false;
        this.descriptionList = new StringList(contentWidth, this.field_146295_m - 135 - 55, contentLeft, 130);
        this.descriptionList.setDrawTopAndBottom(false);
        this.descriptionList.setDrawBackground(false);
        this.updatesButton = (CatalogueCheckBoxButton)this.func_189646_b(new CatalogueCheckBoxButton(6, this.modList.field_148151_d - 14, 7, false));
        this.modList.filterAndUpdateList(this.searchTextField.func_146179_b());
        if (this.selectedModInfo != null) {
            this.setSelectedModInfo(this.selectedModInfo);
            this.updateSelectedModList();
            ModEntry entry = this.modList.getEntryFromInfo(this.selectedModInfo);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.func_146179_b());
    }

    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 2: {
                try {
                    Desktop.getDesktop().open(Loader.instance().getConfigDir().getParentFile().toPath().resolve("mods").toFile());
                }
                catch (Exception e) {
                    Catalogue.LOGGER.error("Problem opening mods folder", (Throwable)e);
                }
                break;
            }
            case 3: {
                try {
                    IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedModInfo);
                    GuiScreen newScreen = guiFactory.createConfigGui((GuiScreen)this);
                    this.field_146297_k.func_147108_a(newScreen);
                }
                catch (Exception e) {
                    Catalogue.LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selectedModInfo.getModId(), (Object)e);
                }
                break;
            }
            case 4: {
                this.openLink(this.selectedModInfo);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.modList.filterAndUpdateList(this.searchTextField.func_146179_b());
                this.updateSelectedModList();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Pair<ResourceLocation, ScreenUtil.Size2i> pair;
        this.activeTooltip = null;
        this.func_146276_q_();
        this.drawModList(mouseX, mouseY, partialTicks);
        this.drawModInfo(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        ModContainer info = (ModContainer)Loader.instance().getIndexedModList().get("catalogue");
        if (info != null) {
            this.loadAndCacheLogo(info);
        }
        if ((pair = LOGO_CACHE.get("catalogue")) != null && pair.getLeft() != null) {
            ResourceLocation textureId = (ResourceLocation)pair.getLeft();
            ScreenUtil.Size2i size = (ScreenUtil.Size2i)pair.getRight();
            this.field_146297_k.func_110434_K().func_110577_a(textureId);
            ScreenUtil.blit(10, 9, 10, 10, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
        }
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip(I18n.func_135052_a((String)"catalogue.gui.info", (Object[])new Object[0]));
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.func_146115_a()) {
            this.setActiveTooltip(I18n.func_135052_a((String)"fml.button.open.mods.folder", (Object[])new Object[0]));
        }
        if (this.activeTooltip != null) {
            this.func_146283_a(this.activeTooltip, mouseX, mouseY + this.tooltipYOffset);
            this.tooltipYOffset = 0;
        }
    }

    protected void func_73869_a(char typedChar, int key) throws IOException {
        if (this.searchTextField.func_146201_a(typedChar, key)) {
            String s = this.searchTextField.func_146179_b();
            this.updateSearchField(s);
            this.modList.filterAndUpdateList(s);
            return;
        }
        super.func_73869_a(typedChar, key);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.modList.func_178039_p();
        this.descriptionList.func_178039_p();
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        String version;
        int versionWidth;
        int contentLeft;
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, mouseX, mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return;
        }
        if (this.selectedModInfo != null && ScreenUtil.isMouseWithin((contentLeft = this.modList.field_148151_d + 12 + 10) + (versionWidth = this.field_146289_q.func_78256_a(version = I18n.func_135052_a((String)"catalogue.gui.version", (Object[])new Object[]{this.selectedModInfo.getDisplayVersion()}))) + 5, 92, 8, 8, mouseX, mouseY)) {
            ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)this.selectedModInfo);
            if (result.status.shouldDraw() && result.url != null) {
                this.openLink(result.url);
            }
        }
        if (ScreenUtil.isMouseWithin(this.searchTextField.field_146209_f, this.searchTextField.field_146210_g, this.searchTextField.field_146218_h, this.searchTextField.field_146219_i, mouseX, mouseY)) {
            if (button == 1) {
                this.searchTextField.func_146180_a("");
                this.updateSearchField("");
                this.modList.filterAndUpdateList("");
                return;
            }
            if (button == 0) {
                String text = this.searchTextField.func_146179_b();
                long currentTine = Minecraft.func_71386_F();
                if (!text.isEmpty() && currentTine - this.lastClickTime < 250L && !this.searchTextField.getIsTextTruncated()) {
                    text = text + this.searchTextField.getSuggestion();
                    this.searchTextField.func_146180_a(text);
                    this.updateSearchField(text);
                    this.modList.filterAndUpdateList(text);
                    this.lastClickTime = currentTine;
                    return;
                }
                this.lastClickTime = currentTine;
            }
        }
        this.searchTextField.func_146192_a(mouseX, mouseY, button);
        super.func_73864_a(mouseX, mouseY, button);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.searchTextField.func_146178_a();
    }

    private void drawModList(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
        ScreenUtil.blit(this.modList.field_148151_d - 24, 10, 24.0f, 0.0f, 8, 8, 64, 16);
        GlStateManager.func_179084_k();
        this.modList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, TextFormatting.BOLD + I18n.func_135052_a((String)"catalogue.gui.title", (Object[])new Object[0]), 70, 10, 0xFFFFFF);
        this.searchTextField.func_146194_f();
        if (ScreenUtil.isMouseWithin(this.modList.field_148151_d - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip(I18n.func_135052_a((String)"catalogue.gui.filter_updates", (Object[])new Object[0]));
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(int mouseX, int mouseY, float partialTicks) {
        this.func_73728_b(this.modList.field_148151_d + 11, -1, this.field_146295_m, -9408400);
        CatalogueModListScreen.func_73734_a((int)(this.modList.field_148151_d + 12), (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)0x66000000);
        this.descriptionList.func_148128_a(mouseX, mouseY, partialTicks);
        int contentLeft = this.modList.field_148151_d + 12 + 10;
        int contentWidth = this.field_146294_l - contentLeft - 10;
        if (this.selectedModInfo != null) {
            ModMetadata metadata;
            this.drawLogo(contentWidth, contentLeft, 10, this.field_146294_l - (this.modList.field_148151_d + 12 + 10) - 10, 50);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)contentLeft, (float)70.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.func_73731_b(this.field_146289_q, this.selectedModInfo.getName(), 0, 0, 0xFFFFFF);
            GlStateManager.func_179121_F();
            String modId = TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"catalogue.gui.modid", (Object[])new Object[]{this.selectedModInfo.getModId()});
            int modIdWidth = this.field_146289_q.func_78256_a(modId);
            this.func_73731_b(this.field_146289_q, modId, contentLeft + contentWidth - modIdWidth, 92, 0xFFFFFF);
            String displayVersion = this.selectedModInfo.getDisplayVersion();
            this.drawStringWithLabel("catalogue.gui.version", displayVersion, contentLeft, 92, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
            int versionWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"catalogue.gui.version", (Object[])new Object[]{displayVersion}));
            String innerVersion = this.selectedModInfo.getVersion();
            if (!displayVersion.equals(innerVersion) && ScreenUtil.isMouseWithin(contentLeft, 92, versionWidth, this.field_146289_q.field_78288_b, mouseX, mouseY)) {
                this.setActiveTooltip(innerVersion);
            }
            ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)this.selectedModInfo);
            if (result.status.shouldDraw() && result.url != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                int vOffset = result.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                ScreenUtil.blit(contentLeft + versionWidth + 5, 92, result.status.getSheetOffset() * 8, vOffset, 8, 8, 64, 16);
                if (ScreenUtil.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    this.setActiveTooltip(I18n.func_135052_a((String)"catalogue.gui.update_available", (Object[])new Object[]{result.url}));
                }
            }
            if ((metadata = this.selectedModInfo.getMetadata()) != null && !metadata.autogenerated) {
                String authors;
                int labelOffset = this.field_146295_m - 20;
                String credits = metadata.credits;
                if (!credits.isEmpty()) {
                    this.drawStringWithLabel("catalogue.gui.credits", credits, contentLeft, labelOffset, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
                    labelOffset -= 15;
                }
                if (!(authors = metadata.getAuthorList()).isEmpty()) {
                    this.drawStringWithLabel("catalogue.gui.authors", authors, contentLeft, labelOffset, contentWidth, mouseX, mouseY, TextFormatting.GRAY, TextFormatting.WHITE);
                }
            }
        } else {
            String message = TextFormatting.GRAY + I18n.func_135052_a((String)"catalogue.gui.no_selection", (Object[])new Object[0]);
            this.func_73732_a(this.field_146289_q, message, contentLeft + contentWidth / 2, this.field_146295_m / 2 - 5, 0xFFFFFF);
        }
    }

    private void drawStringWithLabel(String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, TextFormatting labelColor, TextFormatting contentColor) {
        String formatted = I18n.func_135052_a((String)format, (Object[])new Object[]{text});
        String label = formatted.substring(0, formatted.indexOf(":") + 1);
        String content = formatted.substring(formatted.indexOf(":") + 1);
        if (this.field_146289_q.func_78256_a(formatted) > maxWidth) {
            content = this.field_146289_q.func_78269_a(content, maxWidth - this.field_146289_q.func_78256_a(label) - 7) + "...";
            String credits = labelColor + label;
            credits = credits + contentColor + content;
            this.func_73731_b(this.field_146289_q, credits, x, y, 0xFFFFFF);
            if (ScreenUtil.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip(text);
            }
        } else {
            this.func_73731_b(this.field_146289_q, labelColor + label + contentColor + content, x, y, 0xFFFFFF);
        }
    }

    private void loadAndCacheLogo(ModContainer info) {
        if (LOGO_CACHE.containsKey(info.getModId())) {
            return;
        }
        LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of(null, (Object)new ScreenUtil.Size2i(0, 0)));
        ModContainer modInfo = info;
        ModMetadata metadata = modInfo.getMetadata();
        if (metadata == null) {
            return;
        }
        String s = metadata.logoFile;
        if (s.isEmpty()) {
            return;
        }
        IResourcePack resourcePack = FMLClientHandler.instance().getResourcePackFor(info.getModId());
        BufferedImage logo = null;
        try {
            if (resourcePack != null && !info.getModId().equals("forge")) {
                logo = resourcePack.func_110586_a();
            } else {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(s);
                if (is != null) {
                    logo = TextureUtil.func_177053_a((InputStream)is);
                }
            }
            if (logo == null) {
                return;
            }
            TextureManager textureManager = this.field_146297_k.func_110434_K();
            LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of((Object)textureManager.func_110578_a("modlogo", this.createLogoTexture(logo, true)), (Object)new ScreenUtil.Size2i(logo.getWidth(), logo.getHeight())));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadAndCacheIcon(ModContainer info) {
        ModMetadata metadata;
        if (ICON_CACHE.containsKey(info.getModId())) {
            return;
        }
        ICON_CACHE.put(info.getModId(), (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of(null, (Object)new ScreenUtil.Size2i(0, 0)));
        ModContainer modInfo = info;
        if (modInfo.getCustomModProperties().containsKey("catalogueImageIcon")) {
            String s = (String)modInfo.getCustomModProperties().get("catalogueImageIcon");
            if (s.isEmpty()) {
                return;
            }
            try (InputStream is2 = ((Object)((Object)this)).getClass().getResourceAsStream(s);){
                BufferedImage icon = null;
                if (is2 != null) {
                    icon = TextureUtil.func_177053_a((InputStream)is2);
                }
                if (icon == null) {
                    return;
                }
                TextureManager textureManager = this.field_146297_k.func_110434_K();
                ICON_CACHE.put(info.getModId(), (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of((Object)textureManager.func_110578_a("catalogueicon", this.createLogoTexture(icon, true)), (Object)new ScreenUtil.Size2i(icon.getWidth(), icon.getHeight())));
                return;
            }
            catch (IOException is2) {
                // empty catch block
            }
        }
        if ((metadata = modInfo.getMetadata()) == null) {
            return;
        }
        String s = metadata.logoFile;
        if (s.isEmpty()) {
            return;
        }
        IResourcePack resourcePack = FMLClientHandler.instance().getResourcePackFor(info.getModId());
        BufferedImage logo = null;
        try {
            if (resourcePack != null) {
                logo = resourcePack.func_110586_a();
            } else {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(s);
                if (is != null) {
                    logo = TextureUtil.func_177053_a((InputStream)is);
                }
            }
            if (logo == null) {
                return;
            }
            if (logo.getWidth() == logo.getHeight()) {
                TextureManager textureManager = this.field_146297_k.func_110434_K();
                String modId = info.getModId();
                if (LOGO_CACHE.containsKey(modId) && LOGO_CACHE.get(modId).getLeft() != null) {
                    ICON_CACHE.put(modId, LOGO_CACHE.get(modId));
                    return;
                }
                DynamicTexture texture = this.createLogoTexture(logo, true);
                ScreenUtil.Size2i size = new ScreenUtil.Size2i(logo.getWidth(), logo.getHeight());
                ResourceLocation textureId = textureManager.func_110578_a("catalogueicon", texture);
                ICON_CACHE.put(modId, (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of((Object)textureId, (Object)size));
                LOGO_CACHE.put(modId, (Pair<ResourceLocation, ScreenUtil.Size2i>)Pair.of((Object)textureId, (Object)size));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DynamicTexture createLogoTexture(final BufferedImage image, final boolean smooth) {
        return new DynamicTexture(image){

            public void func_110564_a() {
                TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)image, (boolean)smooth, (boolean)false);
            }
        };
    }

    private void drawLogo(int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModInfo != null) {
            Pair<ResourceLocation, ScreenUtil.Size2i> logoInfo;
            ResourceLocation logoResource = MISSING_BANNER;
            ScreenUtil.Size2i size = new ScreenUtil.Size2i(600, 120);
            if (LOGO_CACHE.containsKey(this.selectedModInfo.getModId()) && (logoInfo = LOGO_CACHE.get(this.selectedModInfo.getModId())).getLeft() != null) {
                logoResource = (ResourceLocation)logoInfo.getLeft();
                size = (ScreenUtil.Size2i)logoInfo.getRight();
            }
            this.field_146297_k.func_110434_K().func_110577_a(logoResource);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            ScreenUtil.blit(x += (contentWidth - width) / 2, y += (maxHeight - height) / 2, width, height, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
            GlStateManager.func_179084_k();
        }
    }

    private void setActiveTooltip(String content) {
        this.activeTooltip = this.field_146289_q.func_78271_c(content, 200);
        this.tooltipYOffset = 0;
    }

    private void setSelectedModInfo(ModContainer selectedModInfo) {
        ModMetadata metadata;
        this.selectedModInfo = selectedModInfo;
        this.loadAndCacheLogo(selectedModInfo);
        this.configButton.field_146125_m = true;
        this.websiteButton.field_146125_m = true;
        this.issueButton.field_146125_m = true;
        this.configButton.field_146124_l = false;
        IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(selectedModInfo);
        if (guiFactory != null) {
            this.configButton.field_146124_l = guiFactory.hasConfigGui();
        }
        if ((metadata = selectedModInfo.getMetadata()) != null && !metadata.autogenerated) {
            this.websiteButton.field_146124_l = !metadata.url.isEmpty();
        }
        this.issueButton.field_146124_l = false;
        int contentLeft = this.modList.field_148151_d + 12 + 10;
        int contentWidth = this.field_146294_l - contentLeft - 10;
        int labelCount = this.getLabelCount(selectedModInfo);
        this.descriptionList.updateSize(contentWidth, this.field_146295_m - 135 - 10 - labelCount * 15, 130, this.field_146295_m - 10 - labelCount * 15);
        this.descriptionList.func_148140_g(contentLeft);
        this.descriptionList.setTextFromInfo(selectedModInfo);
        this.descriptionList.setAmountScrolled(0);
    }

    private int getLabelCount(ModContainer selectedModInfo) {
        int count = 1;
        ModMetadata metadata = selectedModInfo.getMetadata();
        if (metadata != null && !metadata.autogenerated) {
            if (!metadata.credits.isEmpty()) {
                ++count;
            }
            if (!metadata.authorList.isEmpty()) {
                ++count;
            }
        }
        return count;
    }

    private void updateSelectedModList() {
        ModEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModInfo);
        if (selectedEntry != null) {
            this.modList.selectMod(selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.setSuggestion(I18n.func_135052_a((String)"catalogue.gui.search", (Object[])new Object[0]));
        } else {
            Optional<ModContainer> optional = Loader.instance().getActiveModList().stream().filter(info -> info.getName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(ModContainer::getName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getName();
                this.searchTextField.setSuggestion(displayName.substring(length));
            } else {
                this.searchTextField.setSuggestion("");
            }
        }
    }

    private void openLink(@Nullable ModContainer configurable) {
        if (configurable != null) {
            ModMetadata metadata = configurable.getMetadata();
            this.openLink(metadata.url);
        }
    }

    private void openLink(String url) {
        Style style = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        this.func_175276_a(new TextComponentString("").func_150255_a(style));
    }

    private class StringEntry
    implements GuiListExtended.IGuiListEntry {
        private String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void func_192634_a(int index, int left, int top, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            CatalogueModListScreen.this.func_73731_b(CatalogueModListScreen.this.field_146289_q, this.line, left, top, 0xFFFFFF);
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            return true;
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }
    }

    private class StringList
    extends CatalogueListExtended {
        private List<StringEntry> entries;

        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.field_146297_k, width, CatalogueModListScreen.this.field_146295_m, top, top + height, 10);
            this.entries = Lists.newArrayList();
            this.func_148140_g(left);
        }

        public void setTextFromInfo(ModContainer info) {
            this.entries.clear();
            String description = info.getMetadata().description.trim();
            List lines = CatalogueModListScreen.this.field_146289_q.func_78271_c(description, this.func_148139_c());
            for (String line : lines) {
                String cleanLine = line.replace("\n", "").replace("\r", "").trim();
                this.entries.add(new StringEntry(cleanLine));
            }
        }

        @Override
        public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.field_148152_e, this.field_148153_b, this.field_148155_a, this.field_148154_c - this.field_148153_b);
            super.func_148128_a(mouseX, mouseY, partialTicks);
            GL11.glDisable((int)3089);
        }

        protected int func_148137_d() {
            return this.field_148152_e + this.field_148155_a - 7;
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        public int func_148139_c() {
            return this.field_148155_a - 10;
        }

        public GuiListExtended.IGuiListEntry func_148180_b(int index) {
            return this.entries.get(index);
        }
    }

    private class ModEntry
    implements GuiListExtended.IGuiListEntry {
        private final ModContainer info;
        private final ModList list;

        public ModEntry(ModContainer info, ModList list) {
            this.info = info;
            this.list = list;
        }

        public void func_192634_a(int index, int left, int top, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            CatalogueModListScreen.this.func_73731_b(CatalogueModListScreen.this.field_146289_q, this.getFormattedModName(), (left -= 2) + 24, top + 2, 0xFFFFFF);
            CatalogueModListScreen.this.func_73731_b(CatalogueModListScreen.this.field_146289_q, TextFormatting.GRAY + this.info.getDisplayVersion(), left + 24, top + 12, 0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.info);
            if (ICON_CACHE.containsKey(this.info.getModId()) && ((Pair)ICON_CACHE.get(this.info.getModId())).getLeft() != null) {
                ResourceLocation logoResource = TextureMap.field_174945_f;
                ScreenUtil.Size2i size = new ScreenUtil.Size2i(16, 16);
                Pair logoInfo = (Pair)ICON_CACHE.get(this.info.getModId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (ResourceLocation)logoInfo.getLeft();
                    size = (ScreenUtil.Size2i)logoInfo.getRight();
                }
                CatalogueModListScreen.this.field_146297_k.func_110434_K().func_110577_a(logoResource);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179147_l();
                ScreenUtil.blit(left + 4, top + 2, 16, 16, 0.0f, 0.0f, size.width, size.height, size.width, size.height);
                GlStateManager.func_179084_k();
            } else {
                try {
                    GlStateManager.func_179126_j();
                    RenderHelper.func_74520_c();
                    CatalogueModListScreen.this.field_146297_k.func_175599_af().func_175042_a(this.getItemIcon(), left + 4, top + 2);
                    GlStateManager.func_179097_i();
                    RenderHelper.func_74518_a();
                }
                catch (Exception e) {
                    ITEM_CACHE.put(this.info.getModId(), new ItemStack((Block)Blocks.field_150349_c));
                }
            }
            ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)this.info);
            if (result.status.shouldDraw()) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                CatalogueModListScreen.this.field_146297_k.func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                int vOffset = result.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                ScreenUtil.blit(left + rowWidth - 8 - 10, top + 6, result.status.getSheetOffset() * 8, vOffset, 8, 8, 64, 16);
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            this.list.selectMod(slotIndex);
            return true;
        }

        private ItemStack getItemIcon() {
            ItemStack item2;
            if (ITEM_CACHE.containsKey(this.info.getModId())) {
                return (ItemStack)ITEM_CACHE.get(this.info.getModId());
            }
            ITEM_CACHE.put(this.info.getModId(), new ItemStack((Block)Blocks.field_150349_c));
            if (this.info.getModId().equals("forge")) {
                ItemStack anvil = new ItemStack(Blocks.field_150467_bQ);
                ITEM_CACHE.put("forge", anvil);
                return anvil;
            }
            Optional<ItemStack> optional = ForgeRegistries.ITEMS.getValuesCollection().stream().filter(item -> item.getRegistryName().func_110624_b().equals(this.info.getModId())).map(ItemStack::new).findFirst();
            if (optional.isPresent() && !(item2 = optional.get()).func_190926_b()) {
                ItemStack tabItem;
                if (item2.func_77973_b().func_77640_w() != null && (tabItem = item2.func_77973_b().func_77640_w().func_151244_d()) != null && !tabItem.func_190926_b() && tabItem.func_77973_b().getRegistryName().func_110624_b().equals(this.info.getModId())) {
                    item2 = tabItem;
                }
                ITEM_CACHE.put(this.info.getModId(), item2);
                return item2;
            }
            return new ItemStack((Block)Blocks.field_150349_c);
        }

        private String getFormattedModName() {
            String name = this.info.getName();
            int width = this.list.func_148139_c() - (this.list.func_148135_f() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.field_146289_q.func_78256_a(name) > width) {
                name = CatalogueModListScreen.this.field_146289_q.func_78269_a(name, width - 10) + "...";
            }
            if (this.info.getModId().equals("forge") || this.info.getModId().equals("minecraft")) {
                return TextFormatting.DARK_GRAY + name;
            }
            return name;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
        }
    }

    private class ModList
    extends CatalogueListExtended {
        private List<ModEntry> entries;
        private int selectedIndex;

        public ModList() {
            super(CatalogueModListScreen.this.field_146297_k, 150, CatalogueModListScreen.this.field_146295_m, 46, CatalogueModListScreen.this.field_146295_m - 35, 26);
            this.entries = Lists.newArrayList();
            this.selectedIndex = -1;
        }

        @Override
        public void func_148128_a(int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.field_148152_e, this.field_148153_b, this.field_148155_a, this.field_148158_l);
            super.func_148128_a(mouseX, mouseY, partialTicks);
            GL11.glDisable((int)3089);
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
            this.selectedIndex = slotIndex;
            ModEntry entry = this.entries.get(slotIndex);
            CatalogueModListScreen.this.setSelectedModInfo(entry.info);
        }

        public void filterAndUpdateList(String text) {
            List entries = Loader.instance().getActiveModList().stream().filter(info -> info.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(info -> !CatalogueModListScreen.this.updatesButton.selected() || ForgeVersion.getResult((ModContainer)info).status.shouldDraw()).map(info -> new ModEntry((ModContainer)info, this)).sorted(Comparator.comparing(entry -> ((ModEntry)entry).info.getName())).collect(Collectors.toList());
            this.entries = entries;
            this.selectMod(this.getEntryFromInfo(CatalogueModListScreen.this.selectedModInfo));
            this.setAmountScrolled(0);
        }

        public ModEntry getEntryFromInfo(ModContainer info) {
            return this.entries.stream().filter(entry -> ((ModEntry)entry).info == info).findFirst().orElse(null);
        }

        public void selectMod(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }

        public void selectMod(GuiListExtended.IGuiListEntry entry) {
            this.selectMod(this.getEntryIndex(entry));
        }

        public void centerScrollOn(GuiListExtended.IGuiListEntry entry) {
            this.setAmountScrolled(this.field_148149_f * this.getEntryIndex(entry));
        }

        public GuiListExtended.IGuiListEntry func_148180_b(int index) {
            return this.entries.get(index);
        }

        public int getEntryIndex(GuiListExtended.IGuiListEntry entry) {
            return this.entries.indexOf(entry);
        }

        public int func_148139_c() {
            return this.field_148155_a;
        }

        protected int func_148127_b() {
            return this.entries.size();
        }

        protected boolean func_148131_a(int slotIndex) {
            return slotIndex == this.selectedIndex;
        }

        protected int func_148137_d() {
            return this.field_148152_e + this.field_148155_a - 6;
        }
    }
}

