![GitHub](https://img.shields.io/github/license/milanvarady/Applite)
![GitHub release (with filter)](https://img.shields.io/github/v/release/milanvarady/Applite)
![GitHub all releases](https://img.shields.io/github/downloads/milanvarady/Applite/total)
![GitHub contributors](https://img.shields.io/github/contributors/milanvarady/Applite)
![GitHub commits since latest release (by SemVer including pre-releases)](https://img.shields.io/github/commits-since/milanvarady/Applite/latest)


# Applite

User-friendly GUI macOS application for Homebrew Casks

## Table of Contents

1. [Key Features](#key-features)
2. [About](#about)
3. [Screenshots](#screenshots)
4. [Download](#download)
5. [Contact](#contact)
6. [Contributing](#contributing)
7. [Packages Used](#packages-used)
8. [License](#license)
9. [Alternatives](#alternatives)

## Key Features

- Install, update, and uninstall apps with a single click
- Clean and simple UI designed for non-technical users
- Free and open source
- Works with existing brew installation
- Supports system proxy (HTTP, HTTPS, and SOCKS5)
- Handpicked gallery of awesome apps

## About

Applite is a free and open-source macOS application that streamlines the installation and management of third-party apps using [Homebrew](https://brew.sh/). The app is built using [Swift](https://developer.apple.com/swift/) and [SwiftUI](https://developer.apple.com/xcode/swiftui/).

Applite aims to be more of an app store for third-party apps than a full-blown homebrew GUI wrapper. The main goal of the application is to bring the convenience of [Homebrew casks](https://github.com/Homebrew/homebrew-cask) to the non-technical user. So the UI was designed with simplicity and ease of use in mind.

FAQ on the [official website](https://aerolite.dev/applite/FAQ.html).

## Screenshots

![Discover Page Screenshot](https://github.com/user-attachments/assets/d6861ab4-d9ce-40de-982b-8940fc1d1fbf)
![Productivity Category Screenshot](https://github.com/user-attachments/assets/e17846e0-bdbf-4ac3-b922-572ffe69acc2)

## Download

[Download DMG](https://github.com/milanvarady/applite/releases/latest/download/Applite.dmg)

or

`$ brew install --cask applite`

Minimum OS version: **macOS 13+**

## Contact

If you have any questions, feel free to e-mail me: [milan@aerolite.dev](mailto:milan@aerolite.dev)

Or join the [Official Discord Server](https://discord.gg/MpDMH9cPbK).

## Contributing

The project is open to contributions. See the [Contribution Guidelines](docs/CONTRIBUTING.md) for more information.

## Packages used

 - [Homebrew](https://github.com/homebrew)
 - [Sparkle](https://github.com/sparkle-project/Sparkle) - app updates
 - [Ifrit](https://github.com/krisk/fuse-swift), Kusia - fuzzy search
 - [Kingfisher](https://github.com/onevcat/Kingfisher) - web image downloading and caching
 - [ButtonKit](https://github.com/Dean151/ButtonKit), Thomas Durand
 - [DebouncedOnChange](https://github.com/Tunous/DebouncedOnChange), Łukasz Rutkowski
 - [SwiftUI-Shimmer](https://github.com/markiv/SwiftUI-Shimmer), Vikram Kriplaney
 - [CircularProgressSwiftUI](https://github.com/ArnavMotwani/CircularProgressSwiftUI), Arnav Motwani
 - [Appcasks](https://github.com/App-Fair/appcasks/) ([App Fair](https://github.com/App-Fair/App) project) - app icons

## License

Applite is licensed under the [MIT](https://choosealicense.com/licenses/mit/) License. See [LICENSE](LICENSE.txt) for more details.

## Alternatives

- [Cork](https://github.com/buresdv/Cork) (paid)
- [Brewer X](https://panini.house/brewer/) (paid)
- [BrewMate](https://github.com/romankurnovskii/BrewMate) (electron based)
- [Brewlet](https://github.com/zkokaja/Brewlet) (menu bar app)
- [App Fair](https://github.com/App-Fair/App) (looks discontinued)
- [Cakebrew](https://github.com/brunophilipe/Cakebrew) (discontinued)
