
/*!
\ingroup PkgTriangulationsConcepts
\cgalConcept

This concept describes the geometric types and predicates required to build
a regular triangulation. It corresponds to the first template parameter of the class
`CGAL::Regular_triangulation<RegularTriangulationTraits_, TriangulationDataStructure_>`.

\cgalRefines{TriangulationTraits}

\cgalHasModel `CGAL::Epick_d<Dim>`
\cgalHasModel `CGAL::Epeck_d<Dim>`

\sa `TriangulationTraits`
*/
class RegularTriangulationTraits {
public:

/// \name Types
/// @{

/*!
A number type that is a model for `FieldNumberType`.
*/
typedef unspecified_type FT;

/*!
The weighted point type.
*/
typedef unspecified_type Weighted_point_d;

/*!
A function object that must provide the operator
`Point_d operator()(const Weighted_point_d & wp)`, returning
`wp` without its weight.
*/
typedef unspecified_type Construct_point_d;

/*!
A function object that must provide the operator
`FT operator()(const Weighted_point_d & wp)`, returning
the weight of `wp`.
*/
typedef unspecified_type Compute_weight_d;

/*!
A predicate object that must provide the templated operator
`template<typename ForwardIterator> Oriented_side operator()(ForwardIterator start, ForwardIterator end, const Weighted_point_d & p)`.
Let \f$ S \f$ be the power sphere of the weighted points in range `[start,end)`.
The operator returns:
- `ON_ORIENTED_BOUNDARY` if `p` is orthogonal to
\f$ S \f$,

- `ON_NEGATIVE_SIDE` if the power distance between `p` and \f$ S \f$ is
positive.

- `ON_POSITIVE_SIDE` otherwise.

\pre If `Dimension` is `CGAL::Dimension_tag<D>`,
then `std::distance(start,end)=D+1`.
The weighted points in range
`[start,end)` must be affinely independent, i.e., the simplex must
not be flat.
*/
typedef unspecified_type Power_side_of_power_sphere_d;

/*!
A predicate object that must provide the templated operator
`template<typename ForwardIterator> Oriented_side operator()(Flat_orientation_d orient, ForwardIterator start, ForwardIterator end, const Weighted_point_d & p)`.

The points in range `[start,end)` and `p` are supposed to belong to the lower-dimensional flat
whose orientation is given by `orient`.

Let \f$ S \f$ be the power sphere of the weighted points in range `[start,end)`
in this lower dimensional flat.
The operator returns:
- `ON_ORIENTED_BOUNDARY` if `p` is orthogonal to
\f$ S \f$,

- `ON_NEGATIVE_SIDE` if the power distance between `p` and \f$ S \f$ is
positive.

- `ON_POSITIVE_SIDE` otherwise.

\pre `std::distance(start,end)=k+1` where \f$ k\f$ is the number of
points used to construct `orient` (dimension of the flat).
The points in range `[start,end)` must be affinely independent.
`p` must be in the flat generated by these points.
*/
typedef unspecified_type In_flat_power_side_of_power_sphere_d;

/// @}

/// \name Creation
/// @{

/*!
The default constructor (optional).
This is not required when an instance of the traits is provided
to the constructor of `CGAL::Regular_triangulation`.
*/
RegularTriangulationTraits();

/// @}

/// \name Operations
/// The following methods permit access to the traits class's predicates and functors:
/// @{

/*!

*/
Construct_point_d construct_point_d_object() const;

/*!

*/
Compute_weight_d compute_weight_d_object() const;

/*!

*/
Power_side_of_power_sphere_d power_side_of_power_sphere_d_object() const;

/*!

*/
In_flat_power_side_of_power_sphere_d in_flat_power_side_of_power_sphere_d_object() const;

/// @}

}; /* end RegularTriangulationTraits */
