
namespace CGAL {

/*!
\ingroup PkgSegmentDelaunayGraphLinf2Ref

The class `Segment_Delaunay_graph_Linf_filtered_traits_2` provides a model for the
`SegmentDelaunayGraphLinfTraits_2` concept.
The class is derived from class
`CGAL::Segment_Delaunay_graph_filtered_traits_2<CK,CM,EK,EM,FK,FM>`.
We refer to the documentation of the base class
`CGAL::Segment_Delaunay_graph_filtered_traits_2<CK,CM,EK,EM,FK,FM>`
for an explanation of the template parameters.
It usually enough to only specify the CK template argument and a typical
value for CK is CGAL::Simple_cartesian<double> (see also the examples
in the user manual).


\cgalModels `SegmentDelaunayGraphLinfTraits_2`

\sa `CGAL::Segment_Delaunay_graph_filtered_traits_2<CK,CM,EK,EM,FK,FM>`
\sa `CGAL::Segment_Delaunay_graph_Linf_2<Gt,STag,DS>`
\sa `CGAL::Segment_Delaunay_graph_Linf_hierarchy_2<Gt,STag,DS>`
\sa `CGAL::Segment_Delaunay_graph_Linf_traits_2<K,MTag>`
\sa `CGAL::Segment_Delaunay_graph_Linf_traits_without_intersections_2<K,MTag>`
\sa `CGAL::Segment_Delaunay_graph_Linf_filtered_traits_without_intersections_2<CK,CM,EK,EM,FK,FM>`

*/
template< typename CK, typename CM, typename EK, typename EM, typename FK, typename FM >
struct Segment_Delaunay_graph_Linf_filtered_traits_2 {
}; /* end Segment_Delaunay_graph_Linf_filtered_traits_2 */
} /* end namespace CGAL */

namespace CGAL {

/*!
\ingroup PkgSegmentDelaunayGraphLinf2Ref

The class `Segment_Delaunay_graph_Linf_filtered_traits_without_intersections_2`
provides a model for the
`SegmentDelaunayGraphLinfTraits_2` concept.
The class is derived from class
`CGAL::Segment_Delaunay_graph_filtered_traits_without_intersections_2<CK,CM,EK,EM,FK,FM>`.
We refer to the documentation of the base class
`CGAL::Segment_Delaunay_graph_filtered_traits_without_intersections_2<CK,CM,EK,EM,FK,FM>`
for an explanation of the template parameters.
It usually enough to only specify the CK template argument and a typical
value for CK is CGAL::Simple_cartesian<double> (see also the examples
in the user manual).


\cgalModels `SegmentDelaunayGraphLinfTraits_2`

\sa `CGAL::Segment_Delaunay_graph_filtered_traits_without_intersections_2<CK,CM,EK,EM,FK,FM>`
\sa `CGAL::Segment_Delaunay_graph_2<Gt,DS>`
\sa `CGAL::Segment_Delaunay_graph_hierarchy_2<Gt,STag,DS>`
\sa `CGAL::Segment_Delaunay_graph_Linf_traits_2<K,MTag>`
\sa `CGAL::Segment_Delaunay_graph_Linf_traits_without_intersections_2<K,MTag>`
\sa `CGAL::Segment_Delaunay_graph_Linf_filtered_traits_2<CK,CM,EK,EM,FK,FM>`

*/
template< typename CK, typename CM, typename EK, typename EM, typename FK, typename FM >
struct Segment_Delaunay_graph_Linf_filtered_traits_without_intersections_2 {
}; /* end Segment_Delaunay_graph_Linf_filtered_traits_without_intersections_2 */
} /* end namespace CGAL */
