/*
 * This file is part of INAV.
 *
 * INAV is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * INAV is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with INAV.  If not, see <http://www.gnu.org/licenses/>.
 */


#pragma once

#ifdef KAKUTEH7MINI
#define TARGET_BOARD_IDENTIFIER "KTH7"
#define USBD_PRODUCT_STRING     "KAKUTEH7"
#else
#define TARGET_BOARD_IDENTIFIER "KH7M"
#define USBD_PRODUCT_STRING     "KAKUTEH7MINI"

#endif

#define USE_TARGET_CONFIG

#define LED0                    PC2

#define BEEPER                  PC13
#define BEEPER_INVERTED

// *************** IMU generic ***********************




// *************** SPI1 ****************
#define USE_SPI
#define USE_SPI_DEVICE_1
#define SPI1_SCK_PIN            PA5
#define SPI1_MISO_PIN           PA6
#define SPI1_MOSI_PIN           PA7

#if defined(KAKUTEH7MINI)

#define USE_FLASHFS
#define USE_FLASH_M25P16
#define M25P16_CS_PIN           PA4
#define M25P16_SPI_BUS          BUS_SPI1

#define USE_FLASH_W25N01G
#define W25N01G_SPI_BUS BUS_SPI1
#define W25N01G_CS_PIN  PA4

#define ENABLE_BLACKBOX_LOGGING_ON_SPIFLASH_BY_DEFAULT

#elif defined(KAKUTEH7V2)

#define USE_FLASHFS
#define USE_FLASH_W25N01G
#define W25N01G_SPI_BUS BUS_SPI1
#define W25N01G_CS_PIN  PA4

#define ENABLE_BLACKBOX_LOGGING_ON_SPIFLASH_BY_DEFAULT

#else

//Regular Kakute H7

#define USE_SDCARD
#define USE_SDCARD_SPI
#define SDCARD_SPI_BUS          BUS_SPI1
#define SDCARD_CS_PIN           PA4
#define SDCARD_DETECT_INVERTED
#define SDCARD_DETECT_PIN       PA3

#define ENABLE_BLACKBOX_LOGGING_ON_SDCARD_BY_DEFAULT

#endif


// *************** SPI2 ***********************
#define USE_SPI_DEVICE_2
#define SPI2_SCK_PIN            PB13
#define SPI2_MISO_PIN           PB14
#define SPI2_MOSI_PIN           PB15

// *************** SPI4 ***************
#define USE_SPI_DEVICE_4
#define SPI4_SCK_PIN            PE2
#define SPI4_MISO_PIN           PE5
#define SPI4_MOSI_PIN           PE6

//MPU6000
#define USE_IMU_MPU6000
#define IMU_MPU6000_ALIGN       CW270_DEG
#define MPU6000_SPI_BUS         BUS_SPI4
#define MPU6000_CS_PIN          PE4

//BMI270
#define USE_IMU_BMI270
#define BMI270_SPI_BUS          BUS_SPI4
#define BMI270_CS_PIN           PE4

#ifdef KAKUTEH7MINI
#define IMU_BMI270_ALIGN        CW270_DEG
#else
#define IMU_BMI270_ALIGN        CW0_DEG
#endif

#define USE_IMU_ICM42605
#define IMU_ICM42605_ALIGN      CW270_DEG
#define ICM42605_CS_PIN         PE4
#define ICM42605_SPI_BUS        BUS_SPI4

#define USE_MAX7456
#define MAX7456_SPI_BUS         BUS_SPI2
#define MAX7456_CS_PIN          PB12

// *************** I2C /Baro/Mag *********************
#define USE_I2C
#define USE_I2C_DEVICE_1
#define I2C1_SCL                PB6
#define I2C1_SDA                PB7

#define USE_BARO
#define BARO_I2C_BUS            BUS_I2C1
#define USE_BARO_BMP280
#define USE_BARO_MS5611
#define USE_BARO_DPS310
#define USE_BARO_SPL06

#define USE_MAG
#define MAG_I2C_BUS             BUS_I2C1
#define USE_MAG_ALL

#define TEMPERATURE_I2C_BUS     BUS_I2C1
#define PITOT_I2C_BUS           BUS_I2C1

#define USE_RANGEFINDER
#define RANGEFINDER_I2C_BUS     BUS_I2C1

// *************** UART *****************************
#define USE_VCP

#define USE_UART1
#define UART1_TX_PIN            PA9
#define UART1_RX_PIN            PA10

#define USE_UART2
#define UART2_TX_PIN            PD5
#define UART2_RX_PIN            PD6

#define USE_UART3
#define UART3_TX_PIN            PD8
#define UART3_RX_PIN            PD9

#define USE_UART4
#define UART4_TX_PIN            PD1
#define UART4_RX_PIN            PD0

#define USE_UART6
#define UART6_TX_PIN            PC6
#define UART6_RX_PIN            PC7

#define USE_UART7
#define UART7_RX_PIN            PE7

#define SERIAL_PORT_COUNT       7

#define DEFAULT_RX_TYPE         RX_TYPE_SERIAL
#define SERIALRX_PROVIDER       SERIALRX_SBUS
#define SERIALRX_UART           SERIAL_PORT_USART1

// *************** ADC *****************************
#define USE_ADC
#define ADC_INSTANCE                ADC1

#define ADC_CHANNEL_1_PIN           PC0
#define ADC_CHANNEL_2_PIN           PC5
#define ADC_CHANNEL_3_PIN           PC1

#define VBAT_ADC_CHANNEL            ADC_CHN_1
#define CURRENT_METER_ADC_CHANNEL   ADC_CHN_3
#define RSSI_ADC_CHANNEL            ADC_CHN_2

// *************** PINIO ***************************
#define USE_PINIO
#define USE_PINIOBOX

#ifdef KAKUTEH7MINI
#define PINIO1_PIN                  PB11
#define PINIO1_FLAGS				PINIO_FLAGS_INVERTED

#elif defined(KAKUTEH7V2)

#define PINIO1_PIN                  PE13
#define PINIO2_PIN                  PB11
#define PINIO1_FLAGS				PINIO_FLAGS_INVERTED
#define PINIO2_FLAGS				PINIO_FLAGS_INVERTED

#else
#define PINIO1_PIN                  PE13
#endif

// *************** LEDSTRIP ************************
#define USE_LED_STRIP
#define WS2811_PIN                  PD12

#define DEFAULT_FEATURES            (FEATURE_OSD | FEATURE_TELEMETRY | FEATURE_CURRENT_METER | FEATURE_VBAT | FEATURE_TX_PROF_SEL | FEATURE_BLACKBOX)
#define CURRENT_METER_SCALE         250

#define USE_SERIAL_4WAY_BLHELI_INTERFACE

#define TARGET_IO_PORTA 0xffff
#define TARGET_IO_PORTB 0xffff
#define TARGET_IO_PORTC 0xffff
#define TARGET_IO_PORTD 0xffff
#define TARGET_IO_PORTE 0xffff

#define MAX_PWM_OUTPUT_PORTS        8
#define USE_DSHOT
#define USE_ESC_SENSOR

