package bep.hax.gui.screens;

import bep.hax.modules.Meteorites;
import org.jetbrains.annotations.Nullable;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.utils.Cell;
import bep.hax.gui.widgets.meteorites.WMeteorites;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;

/**
 * @author Tas [0xTas] <root@0xTas.dev>
 **/
public class MeteoritesScreen extends WindowScreen {
    private final Meteorites module;
    private @Nullable Cell<? extends WWidget> widget = null;

    public MeteoritesScreen(Meteorites module, GuiTheme theme, String title) {
        super(theme, title);
        this.module = module;
    }

    public @Nullable Cell<? extends WWidget> getWidget() {
        return widget;
    }

    @Override
    public void initWidgets() {
        widget = add(new WMeteorites(module));
    }

    @Override
    public void onClosed() {
        if (module.isActive()) module.toggle();
        if (widget != null && widget.widget() instanceof WMeteorites meteorites) {
            if (meteorites.shouldRestoreColorSettings()) {
                if (meteorites.prevShipColor != null) module.shipColor.set(meteorites.prevShipColor);
                if (meteorites.prevFlameColor != null) module.flameColor.set(meteorites.prevFlameColor);
                if (meteorites.prevBulletColor != null) module.bulletColor.set(meteorites.prevBulletColor);
            }
            if (meteorites.shouldSaveGame()) {
                module.saveGame(meteorites.saveGame());
            }
        }
    }
}
