using UnityEngine;
using Verse;
using Multiplayer.API;

namespace rjw.Settings
{
	public class RJWSettingsController : Mod
	{
		public RJWSettingsController(ModContentPack content) : base(content)
		{
			GetSettings<RJWSettings>();
		}

		public override string SettingsCategory()
		{
			return "RJWSettingsMain".Translate();
		}

		public override void DoSettingsWindowContents(Rect inRect)
		{
			if (MP.IsInMultiplayer)
				return;

			RJWSettings.DoWindowContents(inRect);
		}
	}

	public class RJWDebugController : Mod
	{
		public RJWDebugController(ModContentPack content) : base(content)
		{
			GetSettings<RJWDebugSettings>();
		}

		public override string SettingsCategory()
		{
			return "RJWSettingsDebug".Translate();
		}

		public override void DoSettingsWindowContents(Rect inRect)
		{
			if (MP.IsInMultiplayer)
				return;

			RJWDebugSettings.DoWindowContents(inRect);
		}
	}

	public class RJWPregnancySettingsController : Mod
	{
		public RJWPregnancySettingsController(ModContentPack content) : base(content)
		{
			GetSettings<RJWPregnancySettings>();
		}

		public override string SettingsCategory()
		{
			return "RJWSettingsPregnancy".Translate();
		}

		public override void DoSettingsWindowContents(Rect inRect)
		{
			if (MP.IsInMultiplayer)
				return;

			RJWPregnancySettings.DoWindowContents(inRect);
		}
	}

	public class RJWPreferenceSettingsController : Mod
	{
		public RJWPreferenceSettingsController(ModContentPack content) : base(content)
		{
			GetSettings<RJWPreferenceSettings>();
		}

		public override string SettingsCategory()
		{
			return "RJWSettingsPreference".Translate();
		}

		public override void DoSettingsWindowContents(Rect inRect)
		{
			if (MP.IsInMultiplayer)
				return;

			RJWPreferenceSettings.DoWindowContents(inRect);
		}
	}

	public class RJWHookupSettingsController : Mod
	{
		public RJWHookupSettingsController(ModContentPack content) : base(content)
		{
			GetSettings<RJWHookupSettings>();
		}

		public override string SettingsCategory()
		{
			return "RJWSettingsHookup".Translate();
		}

		public override void DoSettingsWindowContents(Rect inRect)
		{
			if (MP.IsInMultiplayer)
				return;
			RJWHookupSettings.DoWindowContents(inRect);
		}
	}

}