﻿using Verse;
using System.Collections.Generic;

namespace rjw.Modules.Interactions.Preferences
{
	public class RapePreferences : InteractionPreferences
	{
		public override bool IsActive(Pawn pawn, Pawn partner, SexProps props)
		{
			return IsRaping(pawn, partner, props);
		}
		public override IEnumerable<SexPreference> GetPreferences(Pawn pawn, Pawn partner, SexProps props)
		{
			// Dont let your victim use parts they can use to retaliate
			var score = Preference.LastResort;
			yield return new PartnerPartPreference(LewdablePartFamily.Hand, score);
			yield return new PartnerPartPreference(LewdablePartFamily.Mouth, score);
			yield return new PartnerPartPreference(LewdablePartFamily.Beak, score);
			yield return new PartnerPartPreference(LewdablePartFamily.Tail, score);
			yield return new PartnerPartPreference(LewdablePartFamily.Tongue, score);
		}
	}
}
