namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Applies a bonus for a human pawn toward comfort prisoners.
	/// </summary>
	public sealed class S_HumanToComfortPrisoner : FlatAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only applicable for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Cannot involve animals.
			if (request.Category.InvolvesAnimals()) return;
			// And the target must be designated for comfort.
			if (!request.Target.IsDesignatedComfort()) return;

			request.SetPreference(new S_HumanToComfortPrisoner());
		}

		private S_HumanToComfortPrisoner() : base(
			AttractionMode.Social,
			nameof(S_HumanToComfortPrisoner),
			FactorOperation.Add,
			0.2f)
		{ }
	}
}