namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Applies a bonus for an animal observing a designated breedee.
	/// </summary>
	public sealed class S_AnimalToBreedee : FlatAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only applicable for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Observer must be a tamed animal.
			if (!request.Pawn.IsTameAnimal()) return;
			// And the target must be designated for breeding.
			if (!request.Target.IsDesignatedBreeding()) return;

			request.SetPreference(new S_AnimalToBreedee());
		}

		private S_AnimalToBreedee() : base(
			AttractionMode.Social,
			nameof(S_AnimalToBreedee),
			FactorOperation.Add,
			0.2f)
		{ }
	}
}