namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// <para>Handles the observing pawn having a psychic love connection to
	/// the target.</para>
	/// <para>Psychic love is extremely powerful in RimWorld's `RelationsUtility`.</para>
	/// </summary>
	public sealed class R_PsychicLove : AttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Must have psychic love with the target.
			if (!request.Pawn.HasPsychicLoveWith(request.Target)) return;

			request.SetPreference(new R_PsychicLove());
		}

		private R_PsychicLove() : base(
			AttractionMode.Romantic,
			nameof(R_PsychicLove),
			FactorOperation.Multiply)
		{
			Priority = 50;
		}

		protected override float GetOperand(ref AttractionRequest request, float factor) =>
			request.Purpose switch
			{
				// The power of LOVE draws your rage into MY pelvis!
				AttractionPurpose.ForRape when xxx.is_masochist(request.Target) => 1.25f,
				// The power of LOVE compels you to STOP!
				AttractionPurpose.ForRape => 0f,
				// The power of LOVE compels you to think only of ME!
				_ => 10f
			};
	}
}