using UnityEngine;
using Verse;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles the target's romantic relationships, preventing sexual
	/// interactions that encroach on an established couple.
	/// </summary>
	public sealed class R_Homewrecking : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Disabled by certain settings.
			if (RJWSettings.WildMode || RJWSettings.HippieMode) return;
			// Valid only for casual sex.
			if (request.Purpose is not AttractionPurpose.ForFucking) return;
			// Not currently applicable to animals or animal-like people.
			if (request.Pawn.AnimalOrWildMan()) return;
			if (request.Target.AnimalOrWildMan()) return;
			// Psychopaths don't care about the nuances of romantic relationships.
			if (xxx.is_psychopath(request.Pawn)) return;

			request.SetPreference(new R_Homewrecking());
		}

		private R_Homewrecking() : base(
			AttractionMode.Romantic,
			nameof(R_Homewrecking),
			FactorOperation.Multiply,
			WouldBeHomewrecking,
			whenTrue: WhenHomewrecking,
			whenFalse: FixedValue(1f))
		{ }

		private static bool WouldBeHomewrecking(ref AttractionRequest request) =>
			!request.HasLoveRelationWithTarget && xxx.HasNonPolyPartner(request.Target);

		private static float WhenHomewrecking(ref AttractionRequest request, float factor)
		{
			var pawn = request.Pawn;
			var target = request.Target;

			// There are special rules for nymphos.
			if (RJWHookupSettings.NymphosCanHomewreck)
				if (xxx.is_nympho(pawn) && xxx.is_frustrated(pawn))
					return 1f;
			if (RJWHookupSettings.NymphosCanHomewreckReverse)
				if (xxx.is_nympho(target) && xxx.is_frustrated(target))
					return 1f;

			// If both pawns are drunk, we'll use the severity of the least drunk one.
			if (pawn.HasBeerGoggles(out var pSev) && target.HasBeerGoggles(out var tSev))
				return Mathf.Min(pSev, tSev);

			// Otherwise, they're a respectable member of society and will disengage.
			return 0f;
		}
	}
}