using Seeded = rjw.Modules.Rand.Seeded;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Beer goggles can make you see a wildly different perspective...
	/// </summary>
	public sealed class R_BeerGoggles : FlatAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Must be drunk.
			if (!request.Pawn.HasBeerGoggles(out var severity)) return;

			using (Seeded.ForHour(request.Pawn, request.Target))
				request.SetPreference(new R_BeerGoggles(Verse.Rand.Range(-1f, 1f) * severity));
		}

		private R_BeerGoggles(float operand) : base(
			AttractionMode.Romantic,
			nameof(R_BeerGoggles),
			FactorOperation.Add,
			operand)
		{ }
	}
}