namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Manhunting animals are people-raping machines.  Why not?
	/// </summary>
	public sealed class P_Manhunter : PredicatedAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only for sex.
			if (request.Purpose.IsNotForSex()) return;
			// Observer must be a manhunting animal.
			if (!request.Category.AnimalObserver()) return;
			if (!request.Pawn.IsManhunter()) return;

			request.SetPreference(new P_Manhunter());
		}

		private P_Manhunter() : base(
			AttractionMode.Physical,
			nameof(P_Manhunter),
			FactorOperation.Multiply,
			IsManToHunt,
			whenTrue: FixedValue(3f),
			whenFalse: FixedValue(0f))
		{
			Priority = 50;
		}

		private static bool IsManToHunt(ref AttractionRequest request) =>
			request.Target.IsHumanLike();
	}
}