namespace rjw.Modules.Attraction
{
	/// <summary>
	/// An enumeration of standard body types.  Mods can map their custom bodies
	/// to these values to help RJW handle them in a consistent way.
	/// </summary>
	public enum StandardizedBody
	{
		/// <summary>
		/// <para>An unknown body.</para>
		/// <para>This covers two cases: a non-animal with no `story` or a pawn with
		/// a `story.bodyType` that could not be matched to a common achetype.</para>
		/// </summary>
		Unknown,
		/// <summary>
		/// <para>General body for mechanoids.</para>
		/// <para>Also used as a fallback in case of the odd circumstance of a mechanoid
		/// that somehow has a story, but an unknown body-type.</para>
		/// </summary>
		Mechanoid,
		/// <summary>
		/// <para>General body for insectoids.</para>
		/// <para>Also used as a fallback in case of the odd circumstance of an insectoid
		/// that somehow has a story, but an unknown body-type.</para>
		/// </summary>
		Insectoid,
		/// <summary>
		/// <para>The body-type given to any other animal.</para>
		/// <para>Also used as a fallback in case of the odd circumstance of an animal
		/// that somehow has a story, but an unknown body-type.</para>
		/// </summary>
		Animal,
		/// <summary>
		/// The human-like baby body.
		/// </summary>
		Baby,
		/// <summary>
		/// The human-like child body.
		/// </summary>
		Child,
		/// <summary>
		/// The human-like male body.
		/// </summary>
		Male,
		/// <summary>
		/// The human-like female body.
		/// </summary>
		Female,
		/// <summary>
		/// The human-like thin body.
		/// </summary>
		Thin,
		/// <summary>
		/// The human-like hulk body.
		/// </summary>
		Hulk,
		/// <summary>
		/// The human-like fat body.
		/// </summary>
		Fat
	}
}