#nullable enable

using System.Collections.Generic;
using System.Linq;
using RimWorld;
using Verse;
using Verse.AI;

namespace rjw
{
	public class JobGiver_RandomRape : ThinkNode_JobGiver
	{
		/// <summary>
		/// Finds all pawns on the pawn's map that might be good rape victims
		/// for the given pawn.
		/// </summary>
		/// <param name="pawn">The pawn looking for a rape.</param>
		/// <returns>An enumeration of potential victims.</returns>
		public static IEnumerable<Pawn> PotentialVictimsFor(Pawn pawn)
		{
			foreach (var victim in pawn.Map.mapPawns.AllPawnsSpawned)
			{
				// Basic eligibility checks.
				if (victim == pawn) continue;
				if (victim.Suspended) continue;
				if (victim.Drafted) continue;
				if (victim.IsForbidden(pawn)) continue;
				if (victim.HostileTo(pawn)) continue;
				if (!xxx.is_not_dying(victim)) continue;
				if (!xxx.can_get_raped(victim)) continue;
				if (!Pather_Utility.cells_to_target_rape(pawn, victim)) continue;
				if (!pawn.CanReserve(victim, xxx.max_rapists_per_prisoner, 0)) continue;

				yield return victim;
			}
		}

		public Pawn? FindVictim(Pawn pawn)
		{
			// Could be prisoner, colonist, non-hostile outsider, or even animals.
			var targets = PotentialVictimsFor(pawn).ToList();

			// TODO: Should we always disable orientation checks?  We could instead
			// disable them only if there are no targets that fit their preference,
			// so that they don't suddenly break their established character without
			// a good reason.
			foreach (var result in SexAppraiser.FindVictims(pawn, targets, true, true))
				if (Pather_Utility.can_path_to_target(pawn, result.Target))
					return result.Target;

			return null;
		}

		protected override Job? TryGiveJob(Pawn pawn)
		{
			//ModLog.Message(" JobGiver_RandomRape::TryGiveJob( " + xxx.get_pawnname(pawn) + " ) called");
			if (!xxx.can_rape(pawn)) return null;

			if (pawn.health.hediffSet.HasHediff(HediffDef.Named("Hediff_RapeEnemyCD"))) return null;
			pawn.health.AddHediff(HediffDef.Named("Hediff_RapeEnemyCD"), null, null, null);

			if (FindVictim(pawn) is not { } victim) return null;

			//ModLog.Message(" JobGiver_RandomRape::TryGiveJob( " + xxx.get_pawnname(pawn) + " ) - found victim " + xxx.get_pawnname(victim));
			return JobMaker.MakeJob(xxx.RapeRandom, victim);
		}
	}
}