using System.Linq;
using Verse;
using HarmonyLib;
using RimWorld;
using System.Collections;
using System.Collections.Generic;

namespace rjw
{
	[HarmonyPatch(typeof(TraitSet), nameof(TraitSet.GainTrait))]
	internal static class PATCH_TraitSet_GainTrait
	{
		// public void GainTrait(Trait trait, bool suppressConflicts = false);
		[HarmonyPostfix]
		public static void gain_trait(Trait trait)
		{
			// TODO: Psychology and Individuality have their own mechanisms for handling orientation
			if (
				RJWPreferenceSettings.sexuality_distribution == RJWPreferenceSettings.Rjw_sexuality.Psychology ||
				RJWPreferenceSettings.sexuality_distribution == RJWPreferenceSettings.Rjw_sexuality.SYRIndividuality
				)
				return;

			var pawn = trait.pawn;
			if (pawn == null)
			{
				ModLog.Warning($"Could not update orientation upon trait gain {trait} as pawn is null");
				return;
			}

			// During the generation phase, do not interfere with the state of the orientation,
			// since other parts assume that this happens first with the sexualizer.
			if (PawnGenerator.IsBeingGenerated(pawn))
			{
				return;
			}

			CompRJW.UpdateOrientation(pawn);
		}
	}

	[HarmonyPatch(typeof(TraitSet), nameof(TraitSet.RemoveTrait))]
	internal static class PATCH_TraitSet_RemoveTrait
	{
		//public void RemoveTrait(Trait trait, bool unsuppressConflicts = false);
		[HarmonyPostfix]
		public static void remove_trait(Trait trait)
		{
			// TODO: Psychology and Individuality have their own mechanisms for handling orientation
			if (
				RJWPreferenceSettings.sexuality_distribution == RJWPreferenceSettings.Rjw_sexuality.Psychology ||
				RJWPreferenceSettings.sexuality_distribution == RJWPreferenceSettings.Rjw_sexuality.SYRIndividuality
				)
				return;

			var pawn = trait.pawn;
			if (pawn == null)
			{
				ModLog.Warning($"Could not update orientation upon trait removal {trait} as pawn is null");
				return;
			}

			if (RJWPreferenceSettings.sexuality_distribution == RJWPreferenceSettings.Rjw_sexuality.RimJobWorld)
			{
				ModLog.Message($"Trait removal on {xxx.get_pawnname(pawn)} detected. Resetting orientation of pawn for reroll.");
				var comp = pawn.GetCompRJW();
				if (comp != null)
				{
					comp.orientation = Orientation.None;
				}
			}
			CompRJW.UpdateOrientation(pawn);
		}
	}
}