#nullable enable

using HarmonyLib;
using RimWorld;
using Verse;

namespace rjw
{
	///<summary>
	///RJW Designators checks/update
	///update designators only for selected pawn, once, instead of every tick(60 times per sec)
	///</summary>
	[HarmonyPatch(typeof(Selector), nameof(Selector.Select))]
	[StaticConstructorOnStartup]
	static class PawnSelect
	{
		[HarmonyPrefix]
		private static bool UpdateDesignatorPermissions(object obj)
		{
			if (obj is Pawn pawn && pawn.HasComp<CompRJW>())
			{
				//ModLog.Message("Selector patch");
				//ModLog.Message("pawn: " + xxx.get_pawnname(pawn));
				pawn.UpdatePermissions();
			}
			return true;
		}
	}
}