﻿using Verse;
using System.Linq;
using System.Collections.Generic;
using HarmonyLib;

namespace rjw
{
	[HarmonyPatch(typeof(Hediff_MissingPart), "PostAdd")]
	public class Hediff_MissingBodyPart_RemoveParts
	{
		[HarmonyPostfix]
		static void PostAdd(Hediff_MissingPart __instance)
		{
			// Get the body part this hediff is attached to
			var bodyPart = __instance.Part;

			if (bodyPart == null) 
				return;
			if (bodyPart.def == null) 
				return;

			// Do only rjw bodyparts
			if (bodyPart.def == xxx.anusDef || bodyPart.def == xxx.mechanusDef || bodyPart.def == xxx.genitalsDef || bodyPart.def == xxx.mechgenitalsDef || bodyPart.def == xxx.breastsDef || bodyPart.def == xxx.mechbreastsDef)
			{
				// If the body part is valid and has hediffs
				if ( __instance.pawn.health.hediffSet.hediffs.Any(h => h.Part == bodyPart && h.def != __instance.def))
				{
					// Get all hediffs on this body part, excluding the current one
					List<Hediff> hediffsToRemove = __instance.pawn.health.hediffSet.hediffs.Where(h => h.Part == bodyPart && h.def != __instance.def).ToList();

					// Remove each hediff
					foreach (Hediff hediff in hediffsToRemove)
					{
						__instance.pawn.health.RemoveHediff(hediff);
					}
				}
			}
		}
	}
}