﻿#nullable enable

using Verse;
using System.Collections.Generic;

namespace rjw
{
	public class SexPartAdder
	{
		/// <summary>
		/// generate part hediff
		/// </summary>
		public static Hediff MakePart(HediffDef def, Pawn pawn, BodyPartRecord bpr)
		{
			//Log.Message("SexPartAdder::PartMaker ( " + xxx.get_pawnname(pawn) + " ) " + def.defName);
			Hediff hd = HediffMaker.MakeHediff(def, pawn, bpr);
			//Log.Message("SexPartAdder::PartMaker ( " + xxx.get_pawnname(pawn) + " ) " + hd.def.defName);
			HediffComp_SexPart? compHediff = hd.TryGetComp<HediffComp_SexPart>();
			if (compHediff != null)
			{
				//Log.Message("SexPartAdder::PartMaker init comps " + hd.Label);
				compHediff.Init(pawn);
				compHediff.UpdateSeverity();
			}
			return hd;
		}

		/// <summary>
		/// operation - move part data from thing to hediff
		/// </summary>
		public static Hediff recipePartAdder(RecipeDef recipe, Pawn pawn, BodyPartRecord part, List<Thing> ingredients)
		{
			Hediff hd = HediffMaker.MakeHediff(recipe.addsHediff, pawn, part);
			Thing thing = ingredients.Find(x => x.def.defName == recipe.addsHediff.defName);

			CompThingBodyPart? thingComp = thing.TryGetComp<rjw.CompThingBodyPart>();
			HediffComp_SexPart? hediffComp = hd.TryGetComp<rjw.HediffComp_SexPart>();

			if (hediffComp != null && thingComp != null)
			{
				if (thingComp.HasSize())
				{
					if (thingComp.fluid != null && thingComp.fluid != hediffComp.Def.fluid)
					{
						hediffComp.Fluid = thingComp.fluid;
					}
					hediffComp.partFluidMultiplier = thingComp.partFluidMultiplier ?? 1.0f;
					hediffComp.originalOwnerSize = thingComp.originalOwnerSize;
					hediffComp.originalOwnerRace = thingComp.originalOwnerRace;
					hediffComp.previousOwner = thingComp.previousOwner;
					hediffComp.isTransplant = true;
					hediffComp.SetSeverity(thingComp.CalculateSize(hediffComp.GetBodySize()));
				}

				else  //not initialised things, drop pods, trader?  //TODO: figure out how to populate rjw parts at gen
					hd = MakePart(hd.def, pawn, part);
			}

			return hd;
		}

		/// <summary>
		/// operation - move part data from hediff to thing
		/// </summary>
		public static Thing? recipePartRemover(Hediff hd)
		{
			Thing? thing = null;

			if (hd.def.spawnThingOnRemoved != null) 
			{
				thing = ThingMaker.MakeThing(hd.def.spawnThingOnRemoved);

				CompThingBodyPart? thingComp = thing.TryGetComp<rjw.CompThingBodyPart>();
				HediffComp_SexPart? hediffComp = hd.TryGetComp<rjw.HediffComp_SexPart>();

				if (thingComp != null && hediffComp != null)
				{
					thingComp.InitFromComp(hediffComp);
				}
			}
			return thing;
		}

		public static void add_genitals(Pawn pawn, Pawn? parent = null, Gender gender = Gender.None)
		{
			//--Log.Message("Genital_Helper::add_genitals( " + xxx.get_pawnname(pawn) + " ) called");
			BodyPartRecord? partBPR = Genital_Helper.get_genitalsBPR(pawn);

			//--Log.Message("Genital_Helper::add_genitals( " + xxx.get_pawnname(pawn) + " ) - checking genitals");
			if (partBPR == null)
			{
				//--ModLog.Message(" add_genitals( " + xxx.get_pawnname(pawn) + " ) doesn't have a genitals");
				return;
			}
			else if (pawn.health.hediffSet.PartIsMissing(partBPR))
			{
				//--ModLog.Message(" add_genitals( " + xxx.get_pawnname(pawn) + " ) had a genital but was removed.");
				return;
			}

			//override with racesupport
			if (pawn.TryAddRacePart(partBPR, gender))
			{
				return;
			}

			//generic / Legacy adder
			LegacySexPartAdder.AddGenitals(pawn, parent, gender, partBPR);
		}

		public static void add_breasts(Pawn pawn, Pawn? parent = null, Gender gender = Gender.None)
		{
			//--ModLog.Message(" add_breasts( " + xxx.get_pawnname(pawn) + " ) called");
			BodyPartRecord? partBPR = Genital_Helper.get_breastsBPR(pawn);

			if (partBPR == null)
			{
				//--ModLog.Message(" add_breasts( " + xxx.get_pawnname(pawn) + " ) - pawn doesn't have a breasts");
				return;
			}
			else if (pawn.health.hediffSet.PartIsMissing(partBPR))
			{
				//--ModLog.Message(" add_breasts( " + xxx.get_pawnname(pawn) + " ) had breasts but were removed.");
				return;
			}

			//TODO: figure out how to add (flat) breasts to males
			//Check for (flat) breasts to males done in RacepartDef_Helper.cs when severity curve checked
			if (pawn.TryAddRacePart(partBPR, gender))
			{
				return;
			}

			//generic / Legacy adder
			LegacySexPartAdder.AddBreasts(pawn, partBPR, parent);
		}

		public static void add_anus(Pawn pawn, Pawn? parent = null, Gender gender = Gender.None)
		{
			BodyPartRecord? partBPR = Genital_Helper.get_anusBPR(pawn);

			if (partBPR == null)
			{
				//--ModLog.Message(" add_anus( " + xxx.get_pawnname(pawn) + " ) doesn't have an anus");
				return;
			}
			else if (pawn.health.hediffSet.PartIsMissing(partBPR))
			{
				//--ModLog.Message(" add_anus( " + xxx.get_pawnname(pawn) + " ) had an anus but was removed.");
				return;
			}

			if (pawn.TryAddRacePart(partBPR, gender))
			{
				return;
			}

			//generic / Legacy adder
			LegacySexPartAdder.AddAnus(pawn, partBPR, parent);
		}
	}
}
