﻿using System.Linq;
using Verse;
using RimWorld;
using System.Text;
using Multiplayer.API;
using UnityEngine;
using System.Collections.Generic;
using rjw.Modules.Genitals.Enums;
using RimWorld.QuestGen;
using System;

namespace rjw
{
//TODO figure out how this thing works and move eggs to comps

	[StaticConstructorOnStartup]
	public class HediffDef_SexPart : HediffDef
	{
		public const float BaseFluidAmount = 20f;
		private static readonly FloatRange FluidAmountVariation = new(.75f, 1.25f);

		public SexFluidDef fluid;					//cummies/milk - insectjelly/honey etc
		public float fluidMultiplier = 1;           //amount of Milk/Ejaculation/Wetness
		public bool produceFluidOnOrgasm;
		public string defaultBodyPart = "";			//Bodypart to move this part to, after fucking up with pc or other mod
		public List<string> defaultBodyPartList;    //Bodypart list to move this part to, after fucking up with pc or other mod

		public float sizeMultiplier = 1f;

		public PartSizeConfigDef sizeProfile;
		public List<string> partTags = new();
		public GenitalFamily genitalFamily;
		public List<GenitalTag> genitalTags = new();

		public override IEnumerable<string> ConfigErrors()
		{
			foreach (string err in base.ConfigErrors())
			{
				yield return err;
			}
			if (sizeProfile == null && genitalFamily != GenitalFamily.Undefined)
			{
				yield return $"Missing required <{nameof(sizeProfile)}> field. Pick a default from "
				+ "<RJW Defs folder>/ConfigDefs/PartSizeConfigs.xml.";
			}
		}

		[SyncMethod]
		public float GetRandomPartFluidMultiplier()
		{
			return FluidAmountVariation.RandomInRange;
		}

		public float GetFluidAmount(float totalFluidMultiplier)
		{
			return BaseFluidAmount * totalFluidMultiplier;
		}

		public float GetFluidMultiplier(float partSeverity, float partFluidMultipler, float pawnBodySize, float pawnAge=40)
		{
			// should be ~0.5 - 2 for average human
			// biggst vanilla animals with biggest parts, ~8

			var m = this.fluidMultiplier; // Base multiplier for part (pussy/breats/etc)
			m *= Math.Min(50 / Math.Max(1, pawnAge), 1.0f); // Lower when 50+ years old
			m *= pawnBodySize; // Creature size. Usually Race baseBodySize since Severity is already bodySize scaled.

			// Part size. Increases for above Average, decreases for below Average
			// (0 -> 0.5), (0.5 -> 1), (1 -> 2), (2 -> 4)
			m *= Math.Max(1f, partSeverity * 2f); // Above average, uncapped
			m *= Math.Min(1f, partSeverity + 0.5f); // Below average, capped to 0.5

			m *= partFluidMultipler; // Permanent multiplier for part, includes race part multiplier.
			return m;
		}

		[SyncMethod]
		public float GetRandomSize()
		{
			float sample = Rand.Gaussian(0.5f, 0.125f);
			return Mathf.Clamp(sample, 0.01f, 1f) * sizeMultiplier;
		}

		public string GetStandardSizeLabel(float size)
		{
			return stages.FindLast(stage => stage.minSeverity <= size)?.label;
		}
	}
}