﻿using HarmonyLib;
using RimWorld;
using rjw.RMB;
using System.Collections.Generic;
using UnityEngine;
using Verse;

namespace rjw
{
	/// <summary>
	/// Patches FloatMenuMakerMap to add manual RJW interactions to the context menu
	/// </summary>
	[HarmonyPatch(typeof(FloatMenuMakerMap), nameof(FloatMenuMakerMap.ChoicesAtFor))]
	static class Patch_RMBMenu
	{
		public static void Postfix(List<FloatMenuOption> __result, Vector3 clickPos, Pawn pawn)
		{
			RMB_Menu.AddSexFloatMenuOptions(pawn, __result, clickPos);
		}
	}
}