using System.Collections.Generic;
using Verse;

namespace rjw
{
	public class CompProperties_RJW : CompProperties
	{
		public CompProperties_RJW()
		{
			compClass = typeof(CompRJW);
		}
	}

	public class CompProperties_ThingBodyPart : CompProperties
	{
		public HediffDef_SexPart hediffDef;

		public bool guessHediffFromThingDef;

		public CompProperties_ThingBodyPart()
		{
			compClass = typeof(CompThingBodyPart);
		}

		public override IEnumerable<string> ConfigErrors(ThingDef parentDef)
		{
			foreach (string err in base.ConfigErrors(parentDef))
			{
				yield return err;
			}
			if (hediffDef == null && !guessHediffFromThingDef)
			{
				yield return "<hediffDef> must not be null.";
			}
		}

		// TODO: Stop guessing hediff from defName!
		public override void ResolveReferences(ThingDef parentDef)
		{
			base.ResolveReferences(parentDef);

			if (hediffDef == null && guessHediffFromThingDef)
			{
				hediffDef = (HediffDef_SexPart)HediffDef.Named(parentDef.defName);
			}
		}
	}
}