using System;
using System.Collections.Generic;
using System.Linq;
using RimWorld;
using UnityEngine;
using Verse;
using Verse.Sound;
using Multiplayer.API;
using rjw.Modules.Interactions.Contexts;
using rjw.Modules.Interactions.Implementation;
using rjw.Modules.Interactions;
using rjw.Modules.Interactions.Objects;
using rjw.Modules.Interactions.Helpers;
using rjw.Modules.Interactions.Objects.Parts;

using SexType = rjw.xxx.rjwSextype;

namespace rjw
{
	public class SexUtility
	{
		private const float base_sat_per_fuck = 0.40f;
		private const float base_sat_per_quirk = 0.20f;

		public static readonly InteractionDef AnimalSexChat = DefDatabase<InteractionDef>.GetNamed("AnimalSexChat");

		public static readonly List<InteractionDef> SexInterractions = DefDatabase<InteractionDef>.AllDefsListForReading.Where(x => x.HasModExtension<InteractionExtension>()).ToList();

		/// <summary>
		/// Alert checker that is called from several jobs. Checks the pawn relation, and whether it should sound alert. <br/>
		/// notification in top left corner <br/>
		/// rape attempt
		/// </summary>
		public static void RapeTargetAlert(Pawn rapist, Pawn target)
		{
			MessageTypeDef messageType = GetAlertMessageType(rapist, target, RJWPreferenceSettings.rape_attempt_alert);

			if (messageType == null)
			{
				return;
			}

			string messageKey;

			if (xxx.is_mechanoid(rapist))
			{
				messageKey = "RJW_AlertAssault";
			}
			else if (xxx.is_animal(rapist) || xxx.is_animal(target))
			{
				messageKey = "RJW_AlertBreed";
			}
			else
			{
				messageKey = "RJW_AlertRape";
			}

			PawnRelationDef relation = rapist.GetMostImportantRelation(target);
			TaggedString message;

			if (relation == null)
			{
				message = messageKey.Translate(
					rapist.Named("RAPIST"),
					target.Named("TARGET")
				);
			}
			else
			{
				messageKey += "Related";

				message = messageKey.Translate(
					rapist.Named("RAPIST"),
					target.Named("TARGET"),
					relation.GetGenderSpecificLabel(target).Named("RELATION")
				);
			}

			Messages.Message(message, rapist, messageType);
		}

		/// <summary>
		/// Alert checker that is called from several jobs. <br/>
		/// notification in top left corner <br/>
		/// rape started
		/// </summary>
		public static void BeeingRapedAlert(Pawn rapist, Pawn target)
		{
			MessageTypeDef messageType = GetAlertMessageType(rapist, target, RJWPreferenceSettings.rape_alert);

			if (messageType == null)
			{
				return;
			}

			Messages.Message("RJW_AlertBeeingRaped".Translate(target.Named("TARGET")), target, messageType);
		}

		/// <summary>
		/// <para>
		/// Get the type of message that should be issued in a given situation, according to user preferences.
		/// </para>
		/// <para>
		/// Can return null, meaning the message should be suppressed.
		/// </para>
		/// </summary>
		private static MessageTypeDef GetAlertMessageType(Pawn rapist, Pawn target, RJWPreferenceSettings.RapeAlert alert)
		{
			if (target.IsDesignatedComfort())
			{
				Type jobDriverType = rapist.jobs.curDriver.GetType();

				if (jobDriverType == typeof(JobDriver_RapeComfortPawn) && !RJWPreferenceSettings.ShowForCP)
				{
					return null;
				}

				if (jobDriverType == typeof(JobDriver_Breeding) &&
					!RJWPreferenceSettings.ShowForBreeding &&
					target.IsDesignatedBreeding())
				{
					return null;
				}
			}

			switch (alert)
			{
				case RJWPreferenceSettings.RapeAlert.Enabled:
					break;

				case RJWPreferenceSettings.RapeAlert.Humanlikes:
					if (!xxx.is_human(target))
						return null;
					break;

				case RJWPreferenceSettings.RapeAlert.Colonists:
					if (!target.IsColonist)
						return null;
					break;

				case RJWPreferenceSettings.RapeAlert.Silent:
					return MessageTypeDefOf.SilentInput;

				default:
					return null;
			}

			return MessageTypeDefOf.NegativeEvent;
		}

		// Quick method that return a body part by name. Used for checking if a pawn has a specific body part, etc.
		public static BodyPartRecord GetPawnBodyPart(Pawn pawn, string bodyPart)
		{
			return pawn.RaceProps.body.AllParts.Find(x => x.def == DefDatabase<BodyPartDef>.GetNamed(bodyPart));
		}

		public static void CumFilthGenerator(Pawn pawn)
		{
			if (pawn == null) return;
			if (pawn.Dead) return;
			if (xxx.is_slime(pawn)) return;
			if (!RJWSettings.cum_filth) return;

			// Base filth amount.
			// 
			float pawn_cum = 3.0f;

			// Increased output if the pawn has the Messy quirk.
			if (xxx.has_quirk(pawn, "Messy"))
				pawn_cum *= 2.0f;

			var partsProducingFluid = pawn.GetGenitalsList().OfType<ISexPartHediff>().Where(part => part.Def.produceFluidOnOrgasm);

			foreach (var part in partsProducingFluid)
			{
				HediffDef_SexPart def = part.Def;
				HediffComp_SexPart comp = part.GetPartComp();
				SexFluidDef fluid = comp.Fluid;
				if (fluid?.filth == null)
				{
					continue;
				}

				int filthCount = (int)(Math.Ceiling(pawn_cum * comp.FluidMultiplier));
				if (fluid.alwaysProduceFilth && filthCount < 1 )
				{
					filthCount = 1;
				}
				FilthMaker.TryMakeFilth(pawn.PositionHeld, pawn.MapHeld, fluid.filth, pawn.LabelIndefinite(), filthCount, FilthSourceFlags.Pawn);
			}
		}

		// The pawn may or may not clean up the mess after fapping.
		[SyncMethod]
		public static bool ConsiderCleaning(Pawn fapper)
		{
			if (!RJWSettings.cum_filth) return false;
			if (!xxx.has_traits(fapper) || fapper.story == null) return false;
			if (fapper.WorkTagIsDisabled(WorkTags.Cleaning)) return false;

			float do_cleaning = 0.5f; // 50%

			if (!fapper.PositionHeld.Roofed(fapper.Map))
				do_cleaning -= 0.25f; // Less likely to clean if outdoors.

			if (xxx.CTIsActive && fapper.story.traits.HasTrait(xxx.RCT_NeatFreak))
				do_cleaning += 1.00f;

			if (xxx.has_quirk(fapper, "Messy"))
				do_cleaning -= 0.75f;

			switch (fapper.needs?.rest?.CurCategory)
			{
				case RestCategory.Exhausted:
					do_cleaning -= 0.5f;
					break;
				case RestCategory.VeryTired:
					do_cleaning -= 0.3f;
					break;
				case RestCategory.Tired:
					do_cleaning -= 0.1f;
					break;
				case RestCategory.Rested:
					do_cleaning += 0.3f;
					break;
			}

			if (fapper.story.traits.DegreeOfTrait(VanillaTraitDefOf.NaturalMood) == -2) // Depressive
				do_cleaning -= 0.3f;
			if (fapper.story.traits.DegreeOfTrait(TraitDefOf.Industriousness) == 2) // Industrious
				do_cleaning += 1.0f;
			else if (fapper.story.traits.DegreeOfTrait(TraitDefOf.Industriousness) == 1) // Hard worker
				do_cleaning += 0.5f;
			else if (fapper.story.traits.DegreeOfTrait(TraitDefOf.Industriousness) == -1) // Lazy
				do_cleaning -= 0.5f;
			else if (fapper.story.traits.DegreeOfTrait(TraitDefOf.Industriousness) == -2) // Slothful
				do_cleaning -= 1.0f;

			if (xxx.is_ascetic(fapper))
				do_cleaning += 0.2f;

			//Rand.PopState();
			//Rand.PushState(RJW_Multiplayer.PredictableSeed());
			return Rand.Chance(do_cleaning);
		}

		/// <summary>Handles after-sex trait and thought gain, and fluid creation. Initiator of the act (whore, rapist, female zoophile, etc) should be first.</summary>
		[SyncMethod]
		public static void Aftersex(SexProps props)
		{
			if (props.sexType == xxx.rjwSextype.Masturbation)
			{
				AfterMasturbation(props);
				return;
			}

			bool bothInMap = false;

			if (!props.partner.Dead)
				bothInMap = props.pawn.Map != null && props.partner.Map != null; //Added by Hoge. false when called this function for despawned pawn: using for background rape like a kidnappee

			//Rand.PopState();
			//Rand.PushState(RJW_Multiplayer.PredictableSeed());
			if (bothInMap)
			{
				//Catch-all timer increase, for ensuring that pawns don't get stuck repeating jobs.
				if (!props.isCoreLovin)
				{
					props.pawn.rotationTracker.Face(props.partner.DrawPos);
					props.pawn.rotationTracker.FaceCell(props.partner.Position);
				}
				if (!props.partner.Dead)
				{
					if (!props.isCoreLovin)
					{
						props.partner.rotationTracker.Face(props.pawn.DrawPos);
						props.partner.rotationTracker.FaceCell(props.pawn.Position);
					}
					if (RJWSettings.sounds_enabled)
					{
						if (props.isRape)
						{
							if (Rand.Value > 0.30f)
								LifeStageUtility.PlayNearestLifestageSound(props.partner, (ls) => ls.soundAngry, null, null, 1.2f);
							else
								LifeStageUtility.PlayNearestLifestageSound(props.partner, (ls) => ls.soundCall, g => g.soundCall, null, 1.2f);

							props.pawn.Drawer.Notify_MeleeAttackOn(props.partner);
							props.partner.stances.stagger.StaggerFor(Rand.Range(10, 300));
						}
						else
							LifeStageUtility.PlayNearestLifestageSound(props.partner, (ls) => ls.soundCall, g => g.soundCall,null);
					}
					if (props.sexType == xxx.rjwSextype.Vaginal || props.sexType == xxx.rjwSextype.DoublePenetration)
						if (xxx.is_Virgin(props.partner))
						{
							//TODO: bind virginity to parts of pawn
							/*
							string thingdef_penis_name = Genital_Helper.get_penis_all(pawn)?.def.defName ?? "";
							ThingDef thingdef_penis = null;

							Log.Message("SexUtility::thingdef_penis_name " + thingdef_penis_name);
							Log.Message("SexUtility::thingdef_penis 1 " + thingdef_penis);

							if (thingdef_penis_name != "")
								thingdef_penis = (from x in DefDatabase<ThingDef>.AllDefs where x.defName == thingdef_penis_name select x).RandomElement();
							Log.Message("SexUtility::thingdef_penis 2 " + thingdef_penis);

							partner.TakeDamage(new DamageInfo(DamageDefOf.Stab, 1, 999, -1.0f, null, xxx.genitals, thingdef_penis));
							*/
						}
				}

				if (RJWSettings.sounds_enabled && props.isCoreLovin)
					SoundDef.Named("Cum").PlayOneShot(!props.partner.Dead
						? new TargetInfo(props.partner.Position, props.pawn.Map)
						: new TargetInfo(props.pawn.Position, props.pawn.Map));

				if (props.isRape)
				{
					if (Rand.Value > 0.30f)
						LifeStageUtility.PlayNearestLifestageSound(props.pawn, (ls) => ls.soundAngry, null,null, 1.2f);
					else
						LifeStageUtility.PlayNearestLifestageSound(props.pawn, (ls) => ls.soundCall, g => g.soundCall,null, 1.2f);
				}
				else
					LifeStageUtility.PlayNearestLifestageSound(props.pawn, (ls) => ls.soundCall, g => g.soundCall, null);
			}

			if (props.usedCondom)
			{
				if (CondomUtility.UsedCondom != null)
					GenSpawn.Spawn(CondomUtility.UsedCondom, props.pawn.Position, props.pawn.Map);
				CondomUtility.useCondom(props.pawn);
				CondomUtility.useCondom(props.partner);
			}
			else
			{
				if (props.isCoreLovin) // non core handled by jobdriver
				{
					//apply cum to floor:
					CumFilthGenerator(props.pawn);
					CumFilthGenerator(props.partner);

					PregnancyHelper.impregnate(props);
					TransferNutritionCore(props);
				}
			}

			List<Trait> newInitiatorTraits = new(), newReceiverTraits = new();

			if (props.isRape && !props.partner.Dead)
				AfterSexUtility.processBrokenPawn(props.partner, newReceiverTraits);

			//Satisfy(pawn, partner, sextype, rape);

			//TODO: below is fucked up, unfuck it someday
			AfterSexUtility.UpdateRecords(props);
			GiveTraits(props, newInitiatorTraits);
			GiveTraits(props.GetForPartner(), newReceiverTraits);

			if (RJWSettings.sendTraitGainLetters)
			{
				SendTraitGainLetter(props.pawn, newInitiatorTraits);
				SendTraitGainLetter(props.partner, newReceiverTraits);
			}
		}

		// <summary>Solo acts.</summary>
		public static void AfterMasturbation(SexProps props)
		{
			IncreaseTicksToNextLovin(props.pawn);

			//apply cum to floor:
			CumFilthGenerator(props.pawn);

			AfterSexUtility.UpdateRecords(props);

			// No traits from solo. Enable if some are edded. (Voyerism?)
			//check_trait_gain(pawn);
		}

		// Scales alien lifespan to human age. 
		// Some aliens have broken lifespans, that can be manually corrected here.
		public static int ScaleToHumanAge(Pawn pawn, int humanLifespan = 80)
		{
			float pawnAge = pawn.ageTracker.AgeBiologicalYearsFloat;
			float pawnLifespan = pawn.RaceProps.lifeExpectancy;

			if (pawn.def.defName == "Human") return (int)pawnAge; // Human, no need to scale anything.

			// Xen races, all broken and need a fix.
			if (pawn.def.defName.ContainsAny("Alien_Sergal", "Alien_SergalNME", "Alien_Xenn", "Alien_Racc", "Alien_Ferrex", "Alien_Wolvx", "Alien_Frijjid", "Alien_Fennex") && pawnLifespan >= 2000f)
			{
				pawnAge = Math.Min(pawnAge, 80f); // Clamp to 80.
				pawnLifespan = 80f;
			}
			if (pawn.def.defName.ContainsAny("Alien_Gnoll", "Alien_StripedGnoll") && pawnLifespan >= 2000f)
			{
				pawnAge = Math.Min(pawnAge, 60f); // Clamp to 60.
				pawnLifespan = 60f; // Mature faster than humans.
			}

			// Immortal races that mature at similar rate to humans.
			if (pawn.def.defName.ContainsAny("LF_Dragonia", "LotRE_ElfStandardRace", "Alien_Crystalloid", "Alien_CrystalValkyrie"))
			{
				pawnAge = Math.Min(pawnAge, 40f); // Clamp to 40 - never grow 'old'.
				pawnLifespan = 80f;
			}

			float age_scaling = humanLifespan / pawnLifespan;
			float scaled_age = pawnAge * age_scaling;

			if (scaled_age < 1)
				scaled_age = 1;

			return (int)scaled_age;
		}

		// Used in complex impregnation calculation. Pawns/animals with similar parts have better compatibility.
		public static float BodySimilarity(Pawn pawn, Pawn partner)
		{
			float size_adjustment = Mathf.Lerp(0.3f, 1.05f, 1.0f - Math.Abs(pawn.BodySize - partner.BodySize));

			//ModLog.Message(" Size adjustment: " + size_adjustment);

			List<BodyPartDef> pawn_partlist = new List<BodyPartDef> { };
			List<BodyPartDef> pawn_mismatched = new List<BodyPartDef> { };
			List<BodyPartDef> partner_mismatched = new List<BodyPartDef> { };

			//ModLog.Message("Checking compatibility for " + xxx.get_pawnname(pawn) + " and " + xxx.get_pawnname(partner));
			bool pawnHasHands = pawn.health.hediffSet.GetNotMissingParts().Any(part => part.IsInGroup(BodyPartGroupDefOf.RightHand) || part.IsInGroup(BodyPartGroupDefOf.LeftHand));

			foreach (BodyPartRecord part in pawn.RaceProps.body.AllParts)
			{
				pawn_partlist.Add(part.def);
			}
			float pawn_count = pawn_partlist.Count();

			foreach (BodyPartRecord part in partner.RaceProps.body.AllParts)
			{
				partner_mismatched.Add(part.def);
			}
			float partner_count = partner_mismatched.Count();

			foreach (BodyPartDef part in pawn_partlist)
			{
				if (partner_mismatched.Contains(part))
				{
					pawn_mismatched.Add(part);
					partner_mismatched.Remove(part);
				}
			}

			float pawn_mismatch = pawn_mismatched.Count() / pawn_count;
			float partner_mismatch = partner_mismatched.Count() / partner_count;

			//ModLog.Message("Body type similarity for " + xxx.get_pawnname(pawn) + " and " + xxx.get_pawnname(partner) + ": " + Math.Round(((pawn_mismatch + partner_mismatch) * 50) * size_adjustment, 1) + "%");

			return ((pawn_mismatch + partner_mismatch) / 2) * size_adjustment;
		}

		public static void SatisfyPersonal(SexProps props, float satisfaction = 0.4f)
		{
			Pawn pawn = props.pawn;
			Pawn partner = props.partner;
			//--Log.Message("xxx::satisfy( " + pawn_name + ", " + partner_name + ", " + violent + "," + isCoreLovin + " ) - modifying partner satisfaction");
			var sex_need = pawn?.needs?.TryGetNeed<Need_Sex>();
			if (sex_need == null) return;

			float Trait_Satisfaction = 1f;
			float Quirk_Satisfaction = 1f;
			float Stat_Satisfaction = 0f;
			float Circumstances_Satisfaction = 0f; // violence/broken

			float joysatisfaction = satisfaction;

			// Bonus satisfaction from traits
			if (pawn != null && partner != null)
			{
				if (xxx.is_animal(partner) && xxx.is_zoophile(pawn))
				{
					Trait_Satisfaction += 0.5f;
				}
				if (partner.Dead && xxx.is_necrophiliac(pawn))
				{
					Trait_Satisfaction += 0.5f;
				}
			}

			// Calculate bonus satisfaction from quirks
			var quirkCount = Quirk.CountSatisfiedQuirks(props);
			Quirk_Satisfaction += quirkCount * base_sat_per_quirk;

			// Apply sex satisfaction stat (min 0.1 default 1) as a modifier to total satisfaction
			Stat_Satisfaction += Math.Max(xxx.get_sex_satisfaction(pawn), 0.1f);

			// Apply extra multiplier for special/violence circumstances
			Circumstances_Satisfaction += get_satisfaction_circumstance_multiplier(props);

			satisfaction *= Trait_Satisfaction * Quirk_Satisfaction * Stat_Satisfaction;

			joysatisfaction = satisfaction;
			satisfaction *= Circumstances_Satisfaction;
			if (!RJWSettings.Disable_RecreationDrain)
				joysatisfaction *= (Circumstances_Satisfaction - 1);
			else
				joysatisfaction *= Circumstances_Satisfaction;

			//Log.Message("SatisfyPersonal( " + pawn + ", " + satisfaction + " ) - setting pawn sexneed");

			sex_need.CurLevel += satisfaction;

			if (quirkCount > 0)
			{
				Quirk.AddThought(pawn);
			}

			var joy_need = pawn.needs.TryGetNeed<Need_Joy>();
			if (joy_need == null) return;

			joysatisfaction *= joysatisfaction > 0 ? 0.5f : 1f;              // convert half of positive satisfaction to joy
																			 //Log.Message("SatisfyPersonal( " + pawn + ", " + joysatisfaction + " ) - setting pawn joyneed");
			pawn.needs.joy.CurLevel += joysatisfaction;

			//add Ahegao
			//sex&joy > 95%
			//sex&broken

			var lev = sex_need.CurLevel;
			if (lev >= sex_need.thresh_ahegao() &&
				(joy_need.CurLevelPercentage > sex_need.thresh_ahegao()) ||
				(AfterSexUtility.BodyIsBroken(pawn) && pawn.health.hediffSet.GetFirstHediffOfDef(xxx.feelingBroken)?.CurStageIndex >= 3))
			{
				var thoughtDef = DefDatabase<ThoughtDef>.GetNamed("RJW_Ahegao");
				pawn.needs.mood.thoughts.memories.TryGainMemory(thoughtDef);
			}
		}

		[SyncMethod]
		public static void GiveTraits(SexProps props, List<Trait> newTraits)
		{
			var pawn = props.pawn;
			var partner = props.partner;

			if (!xxx.has_traits(pawn) || pawn.records.GetValue(xxx.CountOfSex) <= 10)
			{
				return;
			}

			GiveQuirkTraits(props, newTraits, 0.05f);

			if (props.IsInitiator())
			{
				if (RJWSettings.AddTrait_Rapist && !xxx.is_rapist(pawn) && !xxx.is_masochist(pawn) && props.isRape && pawn.records.GetValue(xxx.CountOfRapedHumanlikes) > 0.12 * pawn.records.GetValue(xxx.CountOfSex))
				{
					var chance = 0.5f;
					if (xxx.is_kind(pawn)) chance -= 0.25f;
					if (xxx.is_prude(pawn)) chance -= 0.25f;
					if (xxx.is_zoophile(pawn)) chance -= 0.25f; // Less interested in raping humanlikes.
					if (xxx.is_ascetic(pawn)) chance -= 0.2f;
					if (xxx.is_bloodlust(pawn)) chance += 0.2f;
					if (xxx.is_psychopath(pawn)) chance += 0.25f;

					if (Rand.Chance(chance))
					{
						Trait rapist = new Trait(xxx.rapist);
						pawn.story.traits.GainTrait(rapist);
						newTraits.Add(rapist);
						//--Log.Message(xxx.get_pawnname(pawn) + " aftersex, not rapist, adding rapist trait");
					}
				}

				if (RJWSettings.AddTrait_Necrophiliac && !xxx.is_necrophiliac(pawn) && partner.Dead && pawn.records.GetValue(xxx.CountOfSexWithCorpse) > 0.5 * pawn.records.GetValue(xxx.CountOfSex))
				{
					Trait necropphiliac = new Trait(xxx.necrophiliac);
					pawn.story.traits.GainTrait(necropphiliac);
					newTraits.Add(necropphiliac);
					//Log.Message(xxx.get_pawnname(necro) + " aftersex, not necro, adding necro trait");					
				}
			}

			if (RJWSettings.AddTrait_Zoophiliac && !xxx.is_zoophile(pawn) && xxx.is_animal(partner)
				&& (pawn.records.GetValue(xxx.CountOfSexWithAnimals) + pawn.records.GetValue(xxx.CountOfSexWithInsects) > 0.5 * pawn.records.GetValue(xxx.CountOfSex)))
			{
				Trait zoophile = new Trait(xxx.zoophile);
				pawn.story.traits.GainTrait(zoophile);
				newTraits.Add(zoophile);

				MemoryThoughtHandler memories = pawn.needs.mood.thoughts.memories;
				foreach (ThoughtDef memory in new[] {xxx.got_bred, xxx.got_anal_bred, xxx.got_groped, xxx.got_licked})
				{
					memories.RemoveMemoriesOfDef(memory);
				}
				//--Log.Message(xxx.get_pawnname(pawn) + " aftersex, not zoo, adding zoo trait");
			}

			if (RJWSettings.AddTrait_Nymphomaniac && !xxx.is_nympho(pawn))
			{
				if (pawn.health.hediffSet.HasHediff(RJWHediffDefOf.HumpShroomAddiction) && pawn.health.hediffSet.HasHediff(RJWHediffDefOf.HumpShroomEffect))
				{
					Trait nymphomaniac = new Trait(xxx.nymphomaniac);
					pawn.story.traits.GainTrait(nymphomaniac);
					newTraits.Add(nymphomaniac);
					//Log.Message(xxx.get_pawnname(pawn) + " is HumpShroomAddicted, not nymphomaniac, adding nymphomaniac trait");
				}
			}
		}

		[SyncMethod]
		private static void GiveQuirkTraits(SexProps props, List<Trait> newTraits, float traitGainChance = 0.05f)
		{
			var pawn = props.pawn;
			if (RJWPreferenceSettings.PlayerIsFootSlut && !pawn.Has(Quirk.Podophile))
			{
				if (props.sexType == xxx.rjwSextype.Footjob)
					if (props.IsSubmissive())
					{
						if (Rand.Chance(traitGainChance) || pawn.story.traits.HasTrait(xxx.footSlut))
						{
							pawn.Add(Quirk.Podophile);
							if (RJWSettings.AddTrait_FootSlut)
							{
								Trait footSlut = new Trait(xxx.footSlut);
								pawn.story.traits.GainTrait(footSlut);
								newTraits.Add(footSlut);
							}
						}
					}
			}
			if (RJWPreferenceSettings.PlayerIsCumSlut && !pawn.Has(Quirk.Cumslut))
			{
				if (props.sexType == xxx.rjwSextype.Fellatio)
					if (props.IsSubmissive())
					{
						if (Rand.Chance(traitGainChance) || pawn.story.traits.HasTrait(xxx.cumSlut))
						{
							pawn.Add(Quirk.Cumslut);
							if (RJWSettings.AddTrait_CumSlut)
							{
								Trait cumSlut = new Trait(xxx.cumSlut);
								pawn.story.traits.GainTrait(cumSlut);
								newTraits.Add(cumSlut);
							}
						}
					}
			}
			if (RJWPreferenceSettings.PlayerIsButtSlut && !pawn.Has(Quirk.Buttslut))
			{
				if (props.sexType == xxx.rjwSextype.Anal)
					if (props.IsSubmissive())
					{
						if (Rand.Chance(traitGainChance) || pawn.story.traits.HasTrait(xxx.buttSlut))
						{
							pawn.Add(Quirk.Buttslut);
							if (RJWSettings.AddTrait_ButtSlut)
							{
								Trait buttSlut = new Trait(xxx.buttSlut);
								pawn.story.traits.GainTrait(buttSlut);
								newTraits.Add(buttSlut);
							}
						}
					}
			}
		}

		private static void SendTraitGainLetter(Pawn pawn, List<Trait> newTraits)
		{
			if (newTraits.Count == 0 || !PawnUtility.ShouldSendNotificationAbout(pawn))
			{
				return;
			}

			TaggedString letterLabel;
			TaggedString letterDescription;
			if (newTraits.Count == 1)
			{
				string traitLabel = newTraits[0].Label;
				
				string letterLabelKey = TranslationKeyFor("LetterLabelGainedTraitFromSex", newTraits[0]);
				letterLabel = letterLabelKey.Translate(traitLabel.Named("TRAIT"), pawn.Named("PAWN")).CapitalizeFirst();
				
				string letterDescriptionKey = TranslationKeyFor("GainedTraitFromSex", newTraits[0]);
				letterDescription = letterDescriptionKey.Translate(traitLabel.Named("TRAIT"), pawn.Named("PAWN")).CapitalizeFirst();
			}
			else
			{
				letterLabel = "LetterLabelGainedMultipleTraitsFromSex".Translate(pawn.Named("PAWN"));
				letterDescription = "GainedMultipleTraitsFromSex".Translate(pawn.Named("PAWN"));

				letterDescription += "\n";
				foreach (var trait in newTraits)
				{
					letterDescription += "\n" + "GainedMultipleTraitsFromSexListItem".Translate(trait.LabelCap);
				}
			}

			Find.LetterStack.ReceiveLetter(letterLabel, letterDescription, LetterDefOf.NeutralEvent, pawn);

			string TranslationKeyFor(string stem, Trait trait)
			{
				string traitKey = stem + trait.def.defName;
				string traitKeyWithDegree = traitKey + trait.Degree;
				if (traitKeyWithDegree.CanTranslate())
				{
					return traitKeyWithDegree;
				}
				if (traitKey.CanTranslate())
				{
					return traitKey;
				}
				return stem;
			}
		}

		// Checks if enough time has passed from previous lovin'.
		public static bool ReadyForLovin(Pawn pawn)
		{
			return Find.TickManager.TicksGame > pawn.mindState.canLovinTick;
		}

		// Checks if enough time has passed from previous search for a hookup.
		// Checks if hookups allowed during working hours, exlcuding nymphs
		public static bool ReadyForHookup(Pawn pawn)
		{
			if (!xxx.is_nympho(pawn) && RJWHookupSettings.NoHookupsDuringWorkHours && ((pawn.timetable != null) ? pawn.timetable.CurrentAssignment : TimeAssignmentDefOf.Anything) == TimeAssignmentDefOf.Work) return false;
			return Find.TickManager.TicksGame > pawn.GetCompRJW().NextHookupTick;
		}

		private static void IncreaseTicksToNextLovin(Pawn pawn)
		{
			if (pawn == null || pawn.Dead) return;
			int currentTime = Find.TickManager.TicksGame;
			if (pawn.mindState.canLovinTick <= currentTime)
				pawn.mindState.canLovinTick = currentTime + GenerateMinTicksToNextLovin(pawn);
		}

		[SyncMethod]
		public static int GenerateMinTicksToNextLovin(Pawn pawn)
		{
			if (DebugSettings.alwaysDoLovin) return 100;
			//Rand.PopState();
			//Rand.PushState(RJW_Multiplayer.PredictableSeed());

			float tick = 1.0f;

			// Nymphs automatically get the tick increase from the trait influence on sex drive.
			if (xxx.is_animal(pawn))
			{
				//var mateMtbHours = pawn.RaceProps.mateMtbHours / 24 * GenDate.TicksPerDay;
				//if (mateMtbHours > 0)
				//	interval = mateMtbHours
				if (RJWSettings.Animal_mating_cooldown == 0)
					tick = 0.75f;
				else
					return RJWSettings.Animal_mating_cooldown * 2500;
			}
			else if (xxx.is_prude(pawn))
				tick = 1.5f;

			if (pawn.Has(Quirk.Vigorous))
				tick *= 0.8f;

			float sex_drive = xxx.get_sex_drive(pawn);
			if (sex_drive <= 0.05f)
				sex_drive = 0.05f;

			float interval = AgeConfigDef.Instance.lovinIntervalHoursByAge.Evaluate(ScaleToHumanAge(pawn));
			float rinterval = Math.Max(0.5f, Rand.Gaussian(interval, 0.3f));
			return (int)(tick * rinterval * (2500.0f / sex_drive));
		}

		public static void IncreaseTicksToNextHookup(Pawn pawn)
		{
			if (pawn == null || pawn.Dead)
				return;

			// There are 2500 ticks per rimworld hour. Sleeping an hour between checks seems like a good start.
			// We could get fancier and weight it by sex drive and stuff, but would people even notice?
			const int TicksBetweenHookups = 2500;

			int currentTime = Find.TickManager.TicksGame;
			pawn.GetCompRJW().NextHookupTick = currentTime + TicksBetweenHookups;
		}

		/// <summary>
		/// <para>Determines the sex type and handles the log output.</para>
		/// <para>`props.pawn` should be initiator of the act (rapist, whore, etc).</para>
		/// <para>`props.partner` should be the target.</para>
		/// </summary>
		public static void ProcessSex(SexProps props)
		{
			//Log.Message("usedCondom=" + usedCondom);
			if (props.pawn == null || props.partner == null)
			{
				if (props.pawn == null)
					ModLog.Error("[SexUtility] ERROR: pawn is null.");
				if (props.partner == null)
					ModLog.Error("[SexUtility] ERROR: partner is null.");
				return;
			}

			IncreaseTicksToNextLovin(props.pawn);
			IncreaseTicksToNextLovin(props.partner);

			Aftersex(props);

			AfterSexUtility.think_about_sex(props);
		}

		[SyncMethod]
		public static SexProps SelectSextype(Pawn pawn, Pawn partner, bool rape, bool whoring)
		{
			var SP = new SexProps();
			SP.pawn = pawn;
			SP.partner = partner;
			SP.isRape = rape;
			SP.isWhoring = whoring;

			//Caufendra's magic is happening here
			InteractionInputs inputs = new InteractionInputs()
			{
				Initiator = pawn,
				Partner = partner,
				IsRape = rape,
				IsWhoring = whoring
			};

			//this should be added as a static readonly but ... since the class is so big,
			//it's probably best not to overload the static constructor
			ILewdInteractionService lewdInteractionService = LewdInteractionService.Instance;

			InteractionOutputs outputs = lewdInteractionService.GenerateInteraction(inputs);

			SP.sexType = outputs.Generated.RjwSexType;
			SP.rulePack = outputs.Generated.RulePack.defName;
			SP.dictionaryKey = outputs.Generated.InteractionDef.Interaction;

			return SP;
		}

		public static void LogSextype(Pawn giving, Pawn receiving, string rulepack, InteractionDef dictionaryKey)
		{
			List<RulePackDef> extraSentencePacks = new List<RulePackDef>();
			if (!rulepack.NullOrEmpty())
				extraSentencePacks.Add(RulePackDef.Named(rulepack));
			LogSextype(giving, receiving, extraSentencePacks, dictionaryKey);
		}

		public static void LogSextype(Pawn giving, Pawn receiving, List<RulePackDef> extraSentencePacks, InteractionDef dictionaryKey)
		{
			if (extraSentencePacks.NullOrEmpty())
			{
				extraSentencePacks = new List<RulePackDef>();
				string extraSentenceRulePack = SexRulePackGet(dictionaryKey);
				if (!extraSentenceRulePack.NullOrEmpty())
					extraSentencePacks.Add(RulePackDef.Named(extraSentenceRulePack));
			}
			PlayLogEntry_Interaction playLogEntry = new PlayLogEntry_Interaction(dictionaryKey, giving, receiving, extraSentencePacks);
			Find.PlayLog.Add(playLogEntry);
		}

		[SyncMethod]
		public static string SexRulePackGet(InteractionDef dictionaryKey)
		{
			var extension = Modules.Interactions.Helpers.InteractionHelper.GetWithExtension(dictionaryKey).Extension;
			string extraSentenceRulePack = "";
			if (!extension.rulepack_defs.NullOrEmpty())
			{
				extraSentenceRulePack = extension.rulepack_defs.RandomElement();
			}

			try
			{
				if (RulePackDef.Named(extraSentenceRulePack) != null)
				{
				}
			}
			catch
			{
				ModLog.Warning("RulePackDef " + extraSentenceRulePack + " for " + dictionaryKey + " not found");
				extraSentenceRulePack = "";
			}
			return extraSentenceRulePack;
		}

		public static xxx.rjwSextype rjwSextypeGet(InteractionDef dictionaryKey)
		{
			var extension = Modules.Interactions.Helpers.InteractionHelper.GetWithExtension(dictionaryKey).Extension;
			var sextype = xxx.rjwSextype.None;
			if (!extension.rjwSextype.NullOrEmpty())
				sextype = ParseHelper.FromString<xxx.rjwSextype>(extension.rjwSextype);

			if (RJWSettings.DevMode) ModLog.Message("rjwSextypeGet:dictionaryKey " + dictionaryKey + " sextype " + sextype);
			return sextype;
		}

		[SyncMethod]
		public static void Sex_Beatings(SexProps props)
		{
			Pawn pawn = props.pawn;
			Pawn partner = props.partner;
			if ((xxx.is_animal(pawn) && xxx.is_animal(partner)))
				return;

			//dont remember what it does, probably manhunter stuff or not? disable and wait reports
			//if (!xxx.is_human(pawn))
			//	return;

			//If a pawn is incapable of violence/has low melee, they most likely won't beat their partner
			if (pawn.skills?.GetSkill(SkillDefOf.Melee).Level < 1)
				return;

			//Rand.PopState();
			//Rand.PushState(RJW_Multiplayer.PredictableSeed());
			float rand_value = Rand.Value;
			//float rand_value = RJW_Multiplayer.RJW_MP_RAND();
			float victim_pain = partner.health.hediffSet.PainTotal;
			// bloodlust makes the aggressor more likely to hit the prisoner
			float beating_chance = xxx.config.base_chance_to_hit_prisoner * (xxx.is_bloodlust(pawn) ? 1.5f : 1.0f);
			// psychopath makes the aggressor more likely to hit the prisoner past the significant_pain_threshold
			float beating_threshold = xxx.is_psychopath(pawn) ? xxx.config.extreme_pain_threshold : pawn.HostileTo(partner) ? xxx.config.significant_pain_threshold : xxx.config.minor_pain_threshold;

			//--Log.Message("roll_to_hit:  rand = " + rand_value + ", beating_chance = " + beating_chance + ", victim_pain = " + victim_pain + ", beating_threshold = " + beating_threshold);
			if ((victim_pain < beating_threshold && rand_value < beating_chance) || (rand_value < (beating_chance / 2) && xxx.is_bloodlust(pawn)))
			{
				Sex_Beatings_Dohit(pawn, partner, props.isRapist);
			}
		}

		[SyncMethod]
		public static void Sex_Beatings_Dohit(Pawn pawn, Pawn partner, bool isRape = false)
		{
			//--Log.Message("   done told her twice already...");
			if (InteractionUtility.TryGetRandomVerbForSocialFight(pawn, out Verb v))
			{
				//Log.Message("   v. : " + v);
				//Log.Message("   v.GetDamageDef : " + v.GetDamageDef());
				//Log.Message("   v.v.tool - " + v.tool.label);
				//Log.Message("   v.v.tool.power base - " + v.tool.power);
				var orgpower = v.tool.power;
				//in case something goes wrong
				try
				{
					//Log.Message("   v.v.tool.power base - " + v.tool.power);
					if (RJWSettings.gentle_rape_beating || !isRape)
					{
						v.tool.power = 0;
						//partner.stances.stunner.StunFor(600, pawn);
					}
					//Log.Message("   v.v.tool.power mod - " + v.tool.power);
					var guilty = true;
					if (!pawn.guilt.IsGuilty)
					{
						guilty = false;
					}
					pawn.meleeVerbs.TryMeleeAttack(partner, v);

					if (pawn.guilt.IsGuilty && !guilty)
						pawn.guilt.Notify_Guilty(0);
				}
				catch
				{ }
				v.tool.power = orgpower;
				//Log.Message("   v.v.tool.power reset - " + v.tool.power);
			}
		}


		// Overrides the current clothing. Defaults to nude, with option to keep headgear on.
		public static void DrawNude(Pawn pawn, bool keep_hat_on = false)
		{
			
			if (!xxx.is_human(pawn)) return;
			if (pawn.Map != Find.CurrentMap) return;
			if (RJWPreferenceSettings.sex_wear == RJWPreferenceSettings.Clothing.Clothed) return;
			var comp = pawn.GetCompRJW();
			if(comp == null) return;
			if (comp.drawNude != true)
				{
				comp.drawNude = true;
				var renderer = pawn.Drawer?.renderer;
				if(renderer != null)
					renderer.SetAllGraphicsDirty();
			}
			
			comp.keep_hat_on = keep_hat_on;
		}

		public static void reduce_rest(Pawn pawn, float x = 1f)
		{
			if (pawn ==  null || x <= 0) return;
			
			if (pawn.Has(Quirk.Vigorous)) x -= x / 2;

			Need_Rest need_rest = pawn.needs.TryGetNeed<Need_Rest>();
			if (need_rest == null)
				return;

			need_rest.CurLevel -= need_rest.RestFallPerTick * x;
		}
		public static void OffsetPsyfocus(Pawn pawn, float x = 0)//0-1
		{
			if (ModsConfig.RoyaltyActive)
			{
				//pawn.psychicEntropy.Notify_Meditated();
				if (pawn.HasPsylink)
				{
					pawn.psychicEntropy.OffsetPsyfocusDirectly(x);
				}
			}
		}

		public static void TransferFluids(SexProps props)
		{
			Pawn pawn = props.pawn, partner = props.partner;
			if (partner == null)
			{
				return;
			}
			
			bool receivedOral = false;
			var possibleFluidParts = Enumerable.Empty<ILewdablePart>();
			var partnerOrifices = Enumerable.Empty<ILewdablePart>();
			
			InteractionWithExtension interaction = InteractionHelper.GetWithExtension(props.dictionaryKey);


			// Checking each sex type individually somehow manages to be less of a pain than figuring out what goes
			// where from the fancier InteractionWithExtension. 
			// This too is the perversity of RimJobWorld.
			if (props.sexType == SexType.Rimming)
			{
				if (interaction.DominantHasFamily(GenitalFamily.Anus)
					|| (props.isReceiver && interaction.SubmissiveHasFamily(GenitalFamily.Anus)))
				{
					receivedOral = true;
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalFamily.Anus);
				}
			}
			else if (props.sexType == SexType.Cunnilingus)
			{
				if (interaction.DominantHasFamily(GenitalFamily.Vagina)
					|| (props.isReceiver && interaction.SubmissiveHasFamily(GenitalFamily.Vagina)))
				{
					receivedOral = true;
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalFamily.Vagina);
				}
			}
			else if (props.sexType == SexType.Fellatio)
			{
				if (interaction.DominantHasTag(GenitalTag.CanPenetrate) || interaction.DominantHasFamily(GenitalFamily.Penis)
					|| (props.isReceiver 
						&& (interaction.SubmissiveHasTag(GenitalTag.CanPenetrate) || interaction.SubmissiveHasFamily(GenitalFamily.Penis))))
				{
					receivedOral = true;
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalTag.CanPenetrate);
				}
			}
			else if (props.sexType == SexType.DoublePenetration)
			{
				if (interaction.DominantHasTag(GenitalTag.CanPenetrate)
					|| (props.isReceiver && interaction.SubmissiveHasTag(GenitalTag.CanPenetrate)))
				{
					partnerOrifices = PartHelper.FindParts(partner, GenitalTag.CanBePenetrated);
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalTag.CanPenetrate);
				}
			}
			else if (props.sexType == SexType.Vaginal)
			{
				if (interaction.DominantHasTag(GenitalTag.CanPenetrate) || interaction.DominantHasFamily(GenitalFamily.Penis)
					|| (props.isReceiver 
						&& (interaction.SubmissiveHasTag(GenitalTag.CanPenetrate) || interaction.SubmissiveHasFamily(GenitalFamily.Penis))))
				{
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalTag.CanPenetrate);

					partnerOrifices = PartHelper.FindParts(partner, GenitalFamily.Vagina)
									.Concat(PartHelper.FindParts(partner, GenitalFamily.FemaleOvipositor));
				}
			}
			else if (props.sexType == SexType.Anal)
			{
				if (interaction.DominantHasTag(GenitalTag.CanPenetrate)
					|| (props.isReceiver && interaction.SubmissiveHasTag(GenitalTag.CanPenetrate)))
				{
					possibleFluidParts = PartHelper.FindParts(pawn, GenitalTag.CanPenetrate);
					partnerOrifices = PartHelper.FindParts(partner, GenitalFamily.Anus);
				}
			}
			else if (props.sexType == SexType.Scissoring)
			{
				possibleFluidParts = PartHelper.FindParts(pawn, GenitalFamily.Vagina)
							.Concat(PartHelper.FindParts(pawn, GenitalFamily.FemaleOvipositor));

				partnerOrifices = PartHelper.FindParts(partner, GenitalFamily.Vagina)
								.Concat(PartHelper.FindParts(partner, GenitalFamily.FemaleOvipositor));
			}
			else if (props.sexType == SexType.Sixtynine)
			{
				receivedOral = true;
				possibleFluidParts = PartHelper.FindParts(pawn, GenitalTag.CanPenetrate)
								.Concat(PartHelper.FindParts(pawn, GenitalFamily.Vagina));
			}

			if (possibleFluidParts.Any())
			{
				var fluidParts = possibleFluidParts.OfType<RJWLewdablePart>()
									   .Select(lp => lp.Part)
									   .Where(p => p.Def.fluid != null && p.Def.produceFluidOnOrgasm);
				
				float nutritionLost = 0f;
				//if (receivedOral && !props.isReceiver)
				if (receivedOral)
				{
					foreach (var part in fluidParts)
					{
						IngestFluids(partner, pawn, part, null, ref nutritionLost);
					}
				}
				else
				{
					foreach (var part in fluidParts.Where(p => p.Def.fluid.ingestThroughAnyOrifice))
					{
						foreach (var orifice in partnerOrifices.Cast<RJWLewdablePart>())
						{
							IngestFluids(partner, pawn, part, orifice.Part, ref nutritionLost);
						}
					}
				}
			}

			if (pawn != partner && pawn.needs != null && partner.needs != null)
			{
				TransferNutritionSucc(props);
			}
		}

		public static void IngestFluids(Pawn receiver, Pawn giver, ISexPartHediff fromPart, ISexPartHediff toPart, ref float totalNutritionLost)
		{
			const float maxNutritionLoss = 0.15f;

			Need_Food receiverFood = receiver.needs?.food, giverFood = giver.needs?.food;

			var fluid = fromPart.GetPartComp().Fluid;
			
			float baseAmount = fromPart.GetPartComp().FluidAmount;
			float amountIngested;

			// Deduct nutrition from giver
			if (giverFood != null && fluid.baseNutritionCost != 0)
			{
				float nutritionCost = Math.Min(baseAmount * fluid.baseNutritionCost, giverFood.CurLevel);
				amountIngested = nutritionCost / fluid.baseNutritionCost;
				if (totalNutritionLost < giverFood.MaxLevel * maxNutritionLoss)
				{
					totalNutritionLost += nutritionCost;
					giverFood.CurLevel -= Math.Min(giverFood.MaxLevel * maxNutritionLoss, nutritionCost);
				}
			}
			else
			{
				amountIngested = baseAmount;
			}

			if (fluid.quenchesThirst)
			{
				TransferThirst(giver, receiver);
			}

			if (fluid.consumable != null)
			{
				var thing = ThingMaker.MakeThing(fluid.consumable);

				thing.stackCount = (int) Math.Max(amountIngested * fluid.consumableFluidRatio, 1f);

				thing.Ingested(receiver, 1000f);
			}
			else
			{
				if (receiverFood != null)
				{
					receiverFood.CurLevel += amountIngested * fluid.baseNutrition;
				}
			}

			if (fluid.ingestionDoers != null)
			{
				foreach (var doer in fluid.ingestionDoers)
				{
					doer.Ingested(receiver, fluid, amountIngested, fromPart, toPart);
				}
			}
		}

		// Takes the nutrition away from the one penetrating(probably) and injects it to the one on the receiving end
		// As with everything in the mod, this could be greatly extended, current focus though is to prevent starvation
		// of those caught in a huge horde of rappers (that may happen with some mods). Currently only used by core lovin'.
		public static void TransferNutritionCore(SexProps props)
		{
			//Log.Message("xxx::TransferNutrition:: " + xxx.get_pawnname(pawn) + " => " + xxx.get_pawnname(partner)); 
			if (props.partner?.needs == null)
			{
				//Log.Message("xxx::TransferNutrition() failed due to lack of transfer equipment or pawn ");
				return;
			}
			if (props.pawn?.needs == null)
			{
				//Log.Message("xxx::TransferNutrition() failed due to lack of transfer equipment or pawn ");
				return;
			}

			TransferNutritionSucc(props);

			//transfer nutrition from presumanbly "giver" to partner
			if (props.sexType == xxx.rjwSextype.Sixtynine ||
				props.sexType == xxx.rjwSextype.Oral ||
				props.sexType == xxx.rjwSextype.Cunnilingus ||
				props.sexType == xxx.rjwSextype.Fellatio)
			{
				Pawn pawn = props.pawn;
				Pawn partner = props.partner;
				Pawn giver, receiver;
				List<Hediff> pawnparts = pawn.GetGenitalsList();
				List<Hediff> partnerparts = partner.GetGenitalsList();
				bool didTransfer = false;

				if (props.sexType == xxx.rjwSextype.Sixtynine || Genital_Helper.has_penis_fertile(pawn, pawnparts) || Genital_Helper.has_ovipositorF(pawn, pawnparts))
				{
					giver = pawn;
					receiver = partner;

					Need_Food need = giver.needs.TryGetNeed<Need_Food>();
					if (need == null)
					{
						//Log.Message("TransferNutrition() " + xxx.get_pawnname(giver) + " doesn't track nutrition in itself, probably shouldn't feed the others");
						return;
					}
					float nutrition_amount = Math.Min(need.MaxLevel / 15f, need.CurLevel); //body size is taken into account implicitly by need.MaxLevel
					giver.needs.food.CurLevel = need.CurLevel - nutrition_amount;
					//Log.Message("TransferNutrition() " + xxx.get_pawnname(giver) + " sent " + nutrition_amount + " of nutrition");

					if (receiver.needs?.TryGetNeed<Need_Food>() != null)
					{
						//Log.Message("xxx::TransferNutrition() " +  xxx.get_pawnname(receiver) + " can receive");
						receiver.needs.food.CurLevel += nutrition_amount;
					}
					TransferThirst(giver, receiver);
					didTransfer = true;
				}

				if (props.sexType == xxx.rjwSextype.Sixtynine || (!didTransfer && (Genital_Helper.has_penis_fertile(partner, partnerparts) || Genital_Helper.has_ovipositorF(partner, partnerparts))))
				{
					giver = partner;
					receiver = pawn;

					Need_Food need = giver.needs?.TryGetNeed<Need_Food>();
					if (need == null)
					{
						//Log.Message("TransferNutrition() " + xxx.get_pawnname(giver) + " doesn't track nutrition in itself, probably shouldn't feed the others");
						return;
					}
					float nutrition_amount = Math.Min(need.MaxLevel / 15f, need.CurLevel); //body size is taken into account implicitly by need.MaxLevel
					giver.needs.food.CurLevel = need.CurLevel - nutrition_amount;
					//Log.Message("TransferNutrition() " + xxx.get_pawnname(giver) + " sent " + nutrition_amount + " of nutrition");

					if (receiver.needs?.TryGetNeed<Need_Food>() != null)
					{
						//Log.Message("TransferNutrition() " +  xxx.get_pawnname(receiver) + " can receive");
						receiver.needs.food.CurLevel += nutrition_amount;
					}
					TransferThirst(giver, receiver);
				}
			}
		}

		public static void TransferThirst(Pawn pawn, Pawn receiver)
		{
			if (xxx.DubsBadHygieneIsActive)
			{
				Need DBHThirst = receiver.needs?.AllNeeds.Find(x => x.def == xxx.DBHThirst);
				if (DBHThirst != null)
				{
					//Log.Message("TransferThirst() " + xxx.get_pawnname(receiver) + " decreasing thirst");
					receiver.needs.TryGetNeed(DBHThirst.def).CurLevel += 0.1f;
				}
			}
		}

		public static void TransferNutritionSucc(SexProps props)
		{
			//succubus mana and rest regen stuff
			if (props.sexType == xxx.rjwSextype.Oral ||
				props.sexType == xxx.rjwSextype.Cunnilingus ||
				props.sexType == xxx.rjwSextype.Fellatio ||
				props.sexType == xxx.rjwSextype.Vaginal ||
				props.sexType == xxx.rjwSextype.Anal ||
				props.sexType == xxx.rjwSextype.DoublePenetration)
			{
				if (xxx.has_traits(props.partner))
				{
					bool gainrest = false;
					if (xxx.RoMIsActive && (props.partner.story.traits.HasTrait(xxx.Succubus) || props.partner.story.traits.HasTrait(xxx.Warlock)))
					{
						Need TM_Mana = props.partner?.needs?.AllNeeds.Find(x => x.def == xxx.TM_Mana);
						if (TM_Mana != null)
						{
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(partner) + " increase mana");
							props.partner.needs.TryGetNeed(TM_Mana.def).CurLevel += 0.1f;
						}
						gainrest = true;
					}

					if (xxx.NightmareIncarnationIsActive)
					{
						foreach (var x in props.partner.AllComps?.Where(x => x.props?.ToString() == "NightmareIncarnation.CompProperties_SuccubusRace"))
						{
							Need NI_Need_Mana = props.partner?.needs?.AllNeeds.Find(x => x.def == xxx.NI_Need_Mana);
							if (NI_Need_Mana != null)
							{
								//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(partner) + " increase mana");
								props.partner.needs.TryGetNeed(NI_Need_Mana.def).CurLevel += 0.1f;
							}
							gainrest = true;
							break;
						}
					}

					if (gainrest)
					{
						Need_Rest need1 = props.pawn.needs?.TryGetNeed<Need_Rest>();
						Need_Rest need2 = props.partner.needs?.TryGetNeed<Need_Rest>();
						if (need1 != null && need2 != null)
						{
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(partner) + " increase rest");
							props.partner.needs.TryGetNeed(need2.def).CurLevel += 0.25f;
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(pawn) + " decrease rest");
							props.pawn.needs.TryGetNeed(need1.def).CurLevel -= 0.25f;
						}
					}
				}

				if (xxx.has_traits(props.pawn))
				{
					bool gainrest = false;
					if (xxx.RoMIsActive && (props.pawn.story.traits.HasTrait(xxx.Succubus) || props.pawn.story.traits.HasTrait(xxx.Warlock)))
					{
						Need TM_Mana = props.pawn?.needs?.AllNeeds.Find(x => x.def == xxx.TM_Mana);
						if (TM_Mana != null)
						{
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(pawn) + " increase mana");
							props.pawn.needs.TryGetNeed(TM_Mana.def).CurLevel += 0.1f;
						}
					}

					if (xxx.NightmareIncarnationIsActive)
					{
						foreach (var x in props.pawn.AllComps?.Where(x => x.props?.ToString() == "NightmareIncarnation.CompProperties_SuccubusRace"))
						{
							Need NI_Need_Mana = props.pawn?.needs?.AllNeeds.Find(x => x.def == xxx.NI_Need_Mana);
							if (NI_Need_Mana != null)
							{
								//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(partner) + " increase mana");
								props.pawn.needs.TryGetNeed(NI_Need_Mana.def).CurLevel += 0.1f;
							}
							gainrest = true;
							break;
						}
					}

					if (gainrest)
					{
						Need_Rest need1 = props.partner.needs.TryGetNeed<Need_Rest>();
						Need_Rest need2 = props.pawn.needs.TryGetNeed<Need_Rest>();
						if (need1 != null && need2 != null)
						{
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(pawn) + " increase rest");
							props.pawn.needs.TryGetNeed(need2.def).CurLevel += 0.25f;
							//Log.Message("TransferNutritionSucc() " + xxx.get_pawnname(partner) + " decrease rest");
							props.partner.needs.TryGetNeed(need1.def).CurLevel -= 0.25f;
						}
					}
				}
			}
		}

		public static float get_broken_consciousness_debuff(Pawn pawn)
		{
			if (pawn == null)
			{
				return 1.0f;
			}

			try
			{
				Hediff broken = pawn.health.hediffSet.GetFirstHediffOfDef(xxx.feelingBroken);
				foreach (PawnCapacityModifier capMod in broken.CapMods)
				{
					if (capMod.capacity == PawnCapacityDefOf.Consciousness)
					{
						if (RJWSettings.DevMode) ModLog.Message("Broken Pawn Consciousness factor: " + capMod.postFactor);
						return capMod.postFactor;
					}
				}

				// fallback
				return 1.0f;
			}
			catch (NullReferenceException)
			{
				//Log.Warning(e.ToString());
				return 1f;
			}
		}

		public static float get_satisfaction_circumstance_multiplier(SexProps props)
		{
			// Get a multiplier for satisfaction that should apply on top of the sex satisfaction stat
			// This is mostly for traits that only affect satisfaction in some circumstances

			Pawn pawn = props.pawn;
			Boolean isViolentSex = props.isRape;

			float multiplier = 1.0f;
			if (xxx.is_human(pawn))
			{
				// Negate consciousness debuffs for broken pawns (counters the sex satisfaction score being affected by low consciousness)
				multiplier = (1.0f / get_broken_consciousness_debuff(pawn));

				// Multiplier bonus for violent traits and violent sex
				if (!props.isReceiver)
				{
					// Rapists/Bloodlusts get 50% more satisfaction from violent encounters, and less from non-violent
					if (isViolentSex)
					{
						if (xxx.is_rapist(pawn) || xxx.is_bloodlust(pawn) || xxx.is_psychopath(pawn))
							multiplier += 0.5f;
						else
							multiplier -= 0.2f;
					}
					else
					{
						if (xxx.is_rapist(pawn) || xxx.is_bloodlust(pawn))
							multiplier -= 0.2f;
						else
							multiplier += 0.2f;
					}
				}
				else if (props.isReceiver)
				{
					// Masochists get 50% more satisfaction from receiving violent sex and 20% less from normal sex
					if (isViolentSex)
					{
						if (xxx.is_masochist(pawn))
							multiplier += 0.5f;
						else
							multiplier -= 0.2f;
					}
					else
					{
						if (xxx.is_masochist(pawn))
							multiplier -= 0.2f;
						else
							multiplier += 0.2f;
					}

					// Multiplier for broken pawns
					if (isViolentSex && AfterSexUtility.BodyIsBroken(pawn))
					{
						// Add bonus satisfaction based on stage
						switch (pawn.health.hediffSet.GetFirstHediffOfDef(xxx.feelingBroken).CurStageIndex)
						{
							case 0:
								break;

							case 1:
								// 50% bonus for stage 2
								//multiplier += 0.5f;
								break;

							case 2:
								// 100% bonus for stage 2
								multiplier += 1.0f;
								break;
						}
					}
				}
				//ModLog.Message("Sex satisfaction multiplier: " + multiplier);
			}
			return multiplier;
		}
	}
}
