﻿using RimWorld;
using Verse;

namespace rjw
{
	// used in Vulnerability StatDef calculation
	public class SkillNeed_CapableOfResisting : SkillNeed_BaseBonus
	{
		public override float ValueFor(Pawn pawn)
		{
			if (pawn.skills == null)
			{
				return 1f;
			}

			int level = NegateSkillBonus(pawn) ? 0 : pawn.skills.GetSkill(skill).Level;
			return ValueAtLevel(level);
		}

		protected virtual bool NegateSkillBonus(Pawn pawn)
		{
			// remove melee bonus for pawns: downed, sleeping/resting/lying, wearing armbinder
			return pawn.Downed
				|| pawn.GetPosture() != PawnPosture.Standing
				// Simple verification on RJW side, but ideally this method should just be overridden in RJW-EX
				|| (xxx.RjwExIsActive && pawn.health.hediffSet.HasHediff(xxx.RjwEx_Armbinder));
		}
	}
}