using System;
using System.Collections.Generic;
using System.Linq;
using RimWorld;
using Verse;

using rjw.Modules.Shared.Extensions;
using rjw.Modules.Interactions.Preferences;

namespace rjw.Modules.Interactions
{
	public static class SexInteractionFinder
	{
		public static List<SexInteractionResolved> FindInteractions(SexProps props)
		{
			var cache = new Internal.FinderCache(props);

			var interactionType = Internal.FindInteractionType(props);

			var interactions = SexUtility.SexInteractions
				.Select(i => new SexInteraction(i))
				.Where(i => i.Extension.tags.Contains(interactionType.AsInteractionTag()));

			
			var available = new List<SexInteractionResolved>();
			foreach (var interaction in interactions)
			{
				foreach (var resolved in Internal.ResolveInteraction(interaction, props, cache))
				{
					available.Add(resolved);
				}
			}

			return available;
		}

		public static class Internal
		{
			public class FinderCache
			{
				public LewdParts initiatorParts;
				public LewdParts recipientParts;

				public FinderCache(SexProps props)
				{
					initiatorParts = new LewdParts(props.initiator, populateAll: true);
					recipientParts = new LewdParts(props.recipient, populateAll: true);
				}
			}

			static IEnumerable<IEnumerable<T>> GetPermutations<T>(IEnumerable<T> list, int length)
			{
				if (length == 1) return list.Select(t => new T[] { t });
				return GetPermutations(list, length - 1).SelectMany(t => list.Where(o => !t.Contains(o)),	(t1, t2) => t1.Concat(new T[] { t2 }));
			}

			public static IEnumerable<SexInteractionResolved> ResolveInteraction(SexInteraction interaction, SexProps props, FinderCache cache)
			{
				if (!TrySatisfyRequirement(props.initiator, cache.initiatorParts, interaction.Extension.initiatorRequirement, props, out var initiatorValidParts))
				{
					yield break;
				}
				if (!TrySatisfyRequirement(props.recipient, cache.recipientParts, interaction.Extension.recipientRequirement, props, out var recipientValidParts))
				{
					yield break;
				}

				// For non-specific interactions there may be multiple way to resolve them.
				// ex: Anus or vagina could be picked in: mutual masturbation, sixty nine, double penetration, bestiality oral

				foreach(var initiatorPermutation in GetPermutations(initiatorValidParts, interaction.Extension.initiatorRequirement.minimumCount ?? 1))
				{
					foreach(var recipientPermutation in GetPermutations(recipientValidParts, interaction.Extension.recipientRequirement.minimumCount ?? 1))
					{
						var resolved = new SexInteractionResolved
						{
							Initiator = props.initiator,
							Recipient = props.recipient,
							Interaction = interaction,
							InitiatorParts = initiatorPermutation.ToList(),
							RecipientParts = recipientPermutation.ToList(),
							Penetrations = FindPenetrations(interaction, initiatorPermutation.ToList(), recipientPermutation.ToList(), cache)
						};

						yield return resolved;
					}
				}
			}

			public static bool TrySatisfyRequirement(Pawn pawn, LewdParts parts, SexInteractionRequirement requirement, SexProps props, out List<ILewdablePart> validParts)
			{
				// SexProps props is here for submod patching. for requirements that depend on both pawns etc. dont remove.

				validParts = null;

				// if pawnStates is specified, pawn must match atleast one state
				if (!requirement.pawnStates.NullOrEmpty())
				{
					if (!requirement.pawnStates.Any(s => pawn.GetPawnState() == s))
					{
						return false;
					}
				}

				// now its about parts, filter available parts based on requirements

				// first filter out parts that are not available (missing or blocked)
				validParts = parts.AllParts.Where(p => LewdPartHelper.IsAvailable(pawn, p)).ToList();

				// if genitalFamilies is specified, each part must match atleast one
				if(!requirement.genitalFamilies.NullOrEmpty())
				{
					validParts = validParts.Where(p => requirement.genitalFamilies.Any(f => p.Family == f.AsLewdPartFamily())).ToList();
				}

				// if partFamilies is specified, each part must match atleast one
				if(!requirement.partFamilies.NullOrEmpty())
				{
					validParts = validParts.Where(p => requirement.partFamilies.Any(f => p.Family == f.AsLewdPartFamily())).ToList();
				}

				// if genitalTags is specified, each part must match atleast one
				if(!requirement.genitalTags.NullOrEmpty())
				{
					validParts = validParts.Where(p => requirement.genitalTags.Any(t => p.HasGenitalTag(t))).ToList();
				}

				// if partTags is specified, each part must match atleast one
				if(!requirement.partTags.NullOrEmpty())
				{
					validParts = validParts.Where(p => p is RJWLewdablePart part && requirement.partTags.Any(t => part.SexPart.Def.partTags.Contains(t))).ToList();
				}

				// if minimumSeverity is specified, each part must have atleast that severity
				if(requirement.minimumSeverity.HasValue)
				{
					validParts = validParts.Where(p => p is RJWLewdablePart part && part.SexPart.AsHediff.Severity >= requirement.minimumSeverity).ToList();
				}

				// if minimumCount is specified, we must have atleast that many parts
				if(requirement.minimumCount.HasValue)
				{
					if(validParts.Count < requirement.minimumCount)
					{
						return false;
					}
				}

				if(validParts.Count == 0)
				{
					return false;
				}

				// removes extra hand/feet if we have more than needed
				var dedupeParts = new List<ILewdablePart>();
				foreach(var part in validParts)
				{
					if (part is VanillaLewdablePart)
					{
						if(dedupeParts.Count(p => p.Family == part.Family) < (requirement.minimumCount ?? 1))
						{
							dedupeParts.Add(part);
						}
					}
					else
					{
						dedupeParts.Add(part);
					}
				}
				validParts = dedupeParts;

				return true;
			}
			public static List<Tuple<ILewdablePart, ILewdablePart>> FindPenetrations(SexInteraction interaction, List<ILewdablePart> initiatorParts, List<ILewdablePart> recipientParts, FinderCache cache)
			{
				var found = new List<Tuple<ILewdablePart, ILewdablePart>>();

				// Handle NonPenetrative interactions, useful when it appears to be penetrative but it's not
				if (interaction.Extension.tags.Contains(SexInteractionTag.NonPenetrative))
				{
					return found;
				}

				// Handle Sixtynine, it cant specify mouths so we need to handle it manually.
				if (interaction.Def.defName == "Sex_Sixtynine")
				{
					var initiatorMouth = cache.initiatorParts.Mouths
						.Where(p => LewdPartHelper.IsAvailable(cache.initiatorParts.Owner, p)).ToList();

					var recipientMouth = cache.recipientParts.Mouths
						.Where(p => LewdPartHelper.IsAvailable(cache.initiatorParts.Owner, p)).ToList();

					var initiatorPart = initiatorParts.First();
					var recipientPart = recipientParts.First();

					if(initiatorMouth.Count > 0 && recipientPart.CouldBePenetrator())
					{
						found.Add(new(recipientPart, initiatorMouth.First()));
					}

					if(recipientMouth.Count > 0 && initiatorPart.CouldBePenetrator())
					{
						found.Add(new(initiatorPart, recipientMouth.First()));
					}
					return found;
				}

				// Tags tagged with Multiple count as two parts
				foreach(var p in initiatorParts.Where(p => p.HasPartTag("Multiple")).ToList())
				{
					initiatorParts.Add(p);
				}
				foreach(var p in recipientParts.Where(p => p.HasPartTag("Multiple")).ToList())
				{
					recipientParts.Add(p);
				}

				// Just try map penetrators to orifices. Multiple penetrators can be mapped to a single orifice.
				if(initiatorParts.Count > 0 && recipientParts.Count > 0)
				{
					var initiatorPenetrators = initiatorParts.Where(p => p.CouldBePenetrator()).ToList();
					var initiatorOrifices = initiatorParts.Where(p => p.CouldBeOrifice()).ToList();
					
					var recipientPenetrators = recipientParts.Where(p => p.CouldBePenetrator()).ToList();
					var recipientOrifices = recipientParts.Where(p => p.CouldBeOrifice()).ToList();

					for(var i = 0; i < initiatorPenetrators.Count; i++)
					{
						if(recipientOrifices.Count == 0)
							break;
						found.Add(new(initiatorPenetrators[i], recipientOrifices[i%recipientOrifices.Count]));
					}

					for(var i = 0; i < recipientPenetrators.Count; i++)
					{
						if(initiatorOrifices.Count == 0)
							break;
						found.Add(new(recipientPenetrators[i], initiatorOrifices[i%initiatorOrifices.Count]));
					}
				}

				return found;
			}

			public static SexInteractionType FindInteractionType(SexProps props)
			{
				if (props.initiator == props.recipient || props.recipient == null)
				{
					return SexInteractionType.Masturbation;
				}

				if (props.recipient.health.Dead == true)
				{
					return SexInteractionType.Necrophilia;
				}

				if (xxx.is_mechanoid(props.initiator))
				{
					return SexInteractionType.Mechanoid;
				}

				//Either one or the other but not both
				if (xxx.is_animal(props.initiator) ^ xxx.is_animal(props.recipient))
				{
					return SexInteractionType.Bestiality;
				}

				if (xxx.is_animal(props.initiator) && xxx.is_animal(props.recipient))
				{
					return SexInteractionType.Animal;
				}

				if (props.isWhoring)
				{
					return SexInteractionType.Whoring;
				}

				if (props.isRape)
				{
					return SexInteractionType.Rape;
				}

				return SexInteractionType.Consensual;
			}
		}
	}
}