using Verse;
using System.Collections.Generic;
using System.Linq;
using rjw.Modules.Shared.Extensions;
using System;

namespace rjw.Modules.Interactions.Preferences
{
	public class GeneralPreferences : InteractionPreferences
	{
		public override bool IsActive(Pawn pawn, Pawn partner, SexProps props)
		{
			// Human heteronormative preferences
			// -> Women dont penetrate Men. Men never get penetrated by Women. Women dont usually anally masturbate.

			if (!xxx.is_human(pawn) || !xxx.is_heterosexual(pawn))
				return false;

			if (pawn.gender == partner.gender && pawn != partner)
				return false;

			if (pawn.gender == Gender.Female)
				return true;

			if (pawn.gender == Gender.Male)
			{
				// Trap detection, Men only have nipples stage breasts.
				var breasts = LewdPartHelper.GetBreasts(pawn);
				if (breasts.NullOrEmpty() || breasts.All(b => b.SexPart.AsHediff.Severity <= 0.01))
					return true;
			}

			// Patch this to check other submod conditions (they have a buttslut quirk or something)

			return false;
		}
		public override IEnumerable<SexPreference> GetPreferences(Pawn pawn, Pawn partner, SexProps props)
		{
			if (pawn.gender == Gender.Male)
			{
				yield return new PenetratedPreference(Preference.LastResort);
			}
			if (pawn.gender == Gender.Female)
			{
				if (pawn != partner)
					yield return new PenetratingPreference(Preference.LastResort);
				else
					yield return new SelfPartPreference(LewdablePartFamily.Anus, Preference.Hate);
			}
		}
	}
}
