﻿using Verse;
using rjw.Modules.Shared;
using System.Collections.Generic;
using System.Linq;
using System;

namespace rjw.Modules.Interactions.Preferences
{
	public class AnimalPreferences : InteractionPreferences
	{
		public override bool IsActive(Pawn pawn, Pawn partner, SexProps props)
		{
			return !xxx.is_insect(pawn) && xxx.is_animal(pawn);
		}
		public override IEnumerable<SexPreference> GetPreferences(Pawn pawn, Pawn partner, SexProps props)
		{
			if (xxx.is_animal(partner))
			{
				if (pawn.def.defName == partner.def.defName)
				{
					// Same species, they know how to mate, its always vaginal
					yield return new TypePreference(xxx.rjwSextype.Vaginal, Preference.Always)
						.IfDissatisfied(new SexPreference(Preference.LastResort));
				}
				else
				{
					// Different species, always penetrative but try for vaginal.
					yield return new PenetrativePreference(Preference.Neutral)
						.IfDissatisfied(new SexPreference(Preference.LastResort));
					yield return new TypePreference(xxx.rjwSextype.Vaginal, Preference.Love);

					// Never oral.
					yield return new SelfPartPreference(LewdablePartFamily.Mouth, Preference.LastResort);
					yield return new PartnerPartPreference(LewdablePartFamily.Mouth, Preference.LastResort);
				}
			}
			else
			{
				// Humanlike
				yield return new PenetratedPreference(Preference.Neutral)
					.IfSatisfied(new TypePreference(xxx.rjwSextype.Vaginal, Preference.Love));
				yield return new PenetratingPreference(Preference.Neutral)
					.IfSatisfied(new TypePreference(xxx.rjwSextype.Oral, Preference.Hate));
			}
		}
	}
}
