using Verse;

namespace rjw.Modules.Attraction.StandardPreferences
{
	/// <summary>
	/// Handles the observer's opinion toward the target.
	/// </summary>
	public sealed class S_Opinion : CurveAttractionPreference
	{
		[StandardPreference]
		public static void ApplyTo(ref AttractionRequest request)
		{
			// Only bother if the pawn can have relations.
			if (request.Pawn.relations is null) return;
			// `OpinionOf` is hard coded to just return zero for non-human targets.
			// However, animals can apparently still have opinions of humans, for
			// whatever reason.
			if (!request.Target.IsHumanLike()) return;
			// Psychopaths do not consider their own opinion of others.
			if (xxx.is_psychopath(request.Pawn)) return;

			request.SetPreference(new S_Opinion());
		}

		/// <summary>
		/// <para>Points of a curve that maps an opinion to a scalar to apply.</para>
		/// <para>The negated opinion is used for rape.</para>
		/// </summary>
		private static readonly CurvePoint[] opinionPoints = new CurvePoint[]
		{
			new(-100f, 0.5f),
			new(-50f, 0.8f),
			new(0f, 1f),
			new(50f, 1.25f),
			new(100f, 1.25f)
		};

		private S_Opinion() : base(
			AttractionMode.Social,
			nameof(S_Opinion),
			GetOpinon,
			opinionPoints)
		{ }

		private static float GetOpinon(ref AttractionRequest request)
		{
			var pawn = request.Pawn;
			var target = request.Target;
			if (pawn.relations?.OpinionOf(target) is not int opinion) return 0f;

			// Opinion is -100 to 100; flip the sign for rape.
			if (request.Purpose.IsForRape()) opinion *= -1;
			return opinion;
		}
	}
}